/*
 * Copyright (C) 2009 by Aiwota Programmer
 * aiwotaprog@tetteke.tk
 *
 * This file is part of Dialektos.
 *
 * Dialektos is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Dialektos is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Dialektos.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef TEXT_VIEW_HXX
#define TEXT_VIEW_HXX

#include <sigc++/signal.h>
#include <string>
#include "text_view_popupable.hxx"


namespace dialektos {

namespace text_element { class Anchor; }

namespace text_view {


class TextView: public Popupable {
  typedef Popupable SuperClass;
  typedef sigc::signal<void ,const std::string&> SignalUriClicked;
public:
  TextView();
  virtual ~TextView();

  /*! @brief Gets the first number of res on the top of the widget. */
  int get_displayed_res_num() const;
  void jump_to_res_num(int res_num);

  SignalUriClicked& signal_uri_clicked() { return sig_uri_clicked_; }
protected:
  virtual void on_anchor_click_event(const text_element::Anchor& elem);

private:
  SignalUriClicked sig_uri_clicked_;
};


} // namespace text_view


} // namepsace dialektos


#endif
