/*
 * Copyright (C) 2009 by Aiwota Programmer
 * aiwotaprog@tetteke.tk
 *
 * This file is part of Dialektos.
 *
 * Dialektos is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Dialektos is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Dialektos.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef TEXT_ELEMENT_RES_NUM_MAP_HXX
#define TEXT_ELEMENT_RES_NUM_MAP_HXX

#include <boost/unordered_map.hpp>
#include <boost/unordered_set.hpp>
#include <vector>

namespace dialektos {

namespace text_element {


class ResNumMap {
  typedef boost::unordered_map<int, boost::unordered_set<int> > ResNumMapType;
public:
  //void increment(int res_num);
  void add(int responded_num, int respondent_num);
  size_t get_count(int res_num) const;

  /*! @brief return the list of respondents to [responded_num]. */
  std::vector<int> get_res_num_list(int responded_num) const;
private:
  ResNumMapType map_;
};


} // namespace text_element

} // namespace dialektos


#endif
