/*
 * Copyright (C) 2009 by Aiwota Programmer
 * aiwotaprog@tetteke.tk
 *
 * This file is part of Dialektos.
 *
 * Dialektos is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Dialektos is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Dialektos.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "text_element_res_num_map.hxx"

#include <algorithm>
#include <vector>


namespace dialektos {

namespace text_element {


void ResNumMap::add(int responded_num, int respondent_num) {
  map_[responded_num].insert(respondent_num);
}

size_t ResNumMap::get_count(int res_num) const {
  ResNumMapType::const_iterator it = map_.find(res_num);
  if (it != map_.end()) return it->second.size();
  return 0;
}

std::vector<int> ResNumMap::get_res_num_list(int responded_num) const {
  ResNumMapType::const_iterator it = map_.find(responded_num);
  if (it != map_.end()) {
    std::vector<int> v(it->second.begin(), it->second.end());
    std::sort(v.begin(), v.end());
    return v;
  }
  return std::vector<int>();
}


} // namespace text_element

} // namespace dialektos
