/*
 * Copyright (C) 2009 by Aiwota Programmer
 * aiwotaprog@tetteke.tk
 *
 * This file is part of Dialektos.
 *
 * Dialektos is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Dialektos is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Dialektos.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "text_element_id_map.hxx"

#include <glibmm/ustring.h>
#include <boost/foreach.hpp>
#include <algorithm>
#include <vector>

namespace Glib {

size_t hash_value(const Glib::ustring& d) {
  size_t h = 0;
  BOOST_FOREACH(const Glib::ustring::value_type& uch, d) {
    boost::hash_combine(h, uch);
  }
  return h;
}

} //namespace Glib


namespace dialektos {

namespace text_element {


void IDMap::add(const Glib::ustring& id, int res_num) {
  map_[id].insert(res_num);
}

size_t IDMap::get_count(const Glib::ustring& id) const {
  IDMapType::const_iterator it = map_.find(id);
  if (it != map_.end()) return it->second.size();
  return 0;
}

std::vector<int> IDMap::get_res_num_list(const Glib::ustring& id) const {
  IDMapType::const_iterator it = map_.find(id);
  if (it != map_.end()) {
    std::vector<int> v(it->second.begin(), it->second.end());
    std::sort(v.begin(), v.end());
    return v;
  }
  return std::vector<int>();
}



} // namespace text_element

} // namespace dialektos
