/*
 * Copyright (C) 2009 by Aiwota Programmer
 * aiwotaprog@tetteke.tk
 *
 * This file is part of Dialektos.
 *
 * Dialektos is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Dialektos is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Dialektos.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef TEXT_ELEMENT_ID_HXX
#define TEXT_ELEMENT_ID_HXX

#include <pangomm/item.h>
#include <pangomm/glyphstring.h>
#include <boost/shared_ptr.hpp>
#include "text_element_anchor.hxx"


namespace dialektos {

namespace text_element {

class IDMap;

/*! @brief text element class for ID */
class ID: public Anchor {
public:
  /*! @brief Constructor.
   *
   * @param range is text represented by Boost.Range concepts.
   * @param bold is whether or not the text is bold.
   * @param id is ID represented by Boost.Range concepts.
   * @param id_map is id map.
   */
  template <typename RangeT, typename RangeT2>
  ID(const RangeT& range, bool bold, const RangeT2& id,
      boost::shared_ptr<const IDMap> id_map) :
    Anchor(range, bold, id), id_map_(id_map) {
  }
  virtual ~ID() {}
protected:
  virtual void do_draw_glyphs(text_view::DrawingSet&, const Pango::Item&,
      const Pango::GlyphString&, double x, double y,
      bool in_selection) const;

private:
  virtual ID* do_clone() const { return new ID(*this); }
  boost::shared_ptr<const IDMap> id_map_;
};


} // namespace text_element

} // namespace dialektos

#endif
