/*
 * Copyright (C) 2009 by Aiwota Programmer
 * aiwotaprog@tetteke.tk
 *
 * This file is part of Dialektos.
 *
 * Dialektos is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Dialektos is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Dialektos.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef TEXT_ELEMENT_CHAR_SIZE_CACHE_HXX
#define TEXT_ELEMENT_CHAR_SIZE_CACHE_HXX

#include <glibmm/refptr.h>
#include <pangomm/item.h>
#include <boost/array.hpp>
#include <boost/utility.hpp>
#include <boost/unordered_map.hpp>


namespace dialektos {

namespace text_element {


class CharSizeCache : boost::noncopyable {

  struct ArrayClass {
    typedef boost::array<int, 1<<16> ArrayType;
    ArrayType array_;
    ArrayClass();
  };

  typedef boost::unordered_map<int, ArrayClass> MapType;
public:
  CharSizeCache();
  double get_char_width(gunichar uch, const Pango::Item&, int font_id);
  double get_char_width(gunichar uch, const Pango::Item&);
private:
  ArrayClass& get_map(int font_id);
  double get_char_width(gunichar uch, const Pango::Item&, ArrayClass& cache);
  MapType map_;
};


} // namespace text_element

} // namespace dialektos


#endif
