/*
 * Copyright (C) 2009 by Aiwota Programmer
 * aiwotaprog@tetteke.tk
 *
 * This file is part of Dialektos.
 *
 * Dialektos is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Dialektos is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Dialektos.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "text_element_char_size_cache.hxx"

#include <pangomm/glyphstring.h>
#include <boost/foreach.hpp>


namespace dialektos {

namespace text_element {


namespace {
inline gunichar ucs4_to_ucs2(const gunichar ucs4) {
  return (ucs4 >> 16) ? '?' : (ucs4 & 0x0000ffff);
}
} // anonymous namespace


CharSizeCache::ArrayClass::ArrayClass() : array_() {
  BOOST_FOREACH(int& i, array_) i = -1;
}


CharSizeCache::CharSizeCache() {}

CharSizeCache::ArrayClass& CharSizeCache::get_map(int font_id) {
  return map_[font_id];
}

double CharSizeCache::get_char_width(
    gunichar uch, const Pango::Item& item, ArrayClass& cache) {

  const gunichar ucs2 = ucs4_to_ucs2(uch);

  int width = cache.array_[ucs2];
  if (width == -1) {
    const Glib::ustring text(1, uch);
    Pango::GlyphString glyphs = item.shape(text);
    width = glyphs.get_width();
    cache.array_[ucs2] = width;
  }
  return double(width) / Pango::SCALE;
}

double CharSizeCache::get_char_width(
    gunichar uch, const Pango::Item& item, int font_id) {
  return get_char_width(uch, item, get_map(font_id));
}

double CharSizeCache::get_char_width(gunichar uch, const Pango::Item& item) {
  Pango::Analysis analysis = item.get_analysis();
  Glib::RefPtr<Pango::Font> font = analysis.get_font();
  const int font_id = reinterpret_cast<long int>(font->gobj());
  return get_char_width(uch, item, get_map(font_id));
}


} // namespace text_element

} // namespace dialektos
