/*
 * Copyright (C) 2009 by Aiwota Programmer
 * aiwotaprog@tetteke.tk
 *
 * This file is part of Dialektos.
 *
 * Dialektos is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Dialektos is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Dialektos.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef TEXT_ELEMENT_ANCHOR_HXX
#define TEXT_ELEMENT_ANCHOR_HXX

#include <glibmm/ustring.h>
#include <gdkmm/cursor.h>
#include <boost/range.hpp>
#include <pangomm/item.h>
#include <pangomm/glyphstring.h>
#include <boost/unordered_map.hpp>
#include "text_element_plain.hxx"


namespace dialektos {

namespace text_element {


/*! @brief text element for Anchor. */
class Anchor: public Plain {
public:

  /*! @brief Constructor.
   *
   * @param range is text represented by Boost.Range concepts.
   * @param bold is whether or not the text is bold.
   * @param href is href represented by Boost.Range concepts.
   */
  template <typename RangeT, typename RangeT2>
  Anchor(const RangeT& range, bool bold, const RangeT2 href) :
    Plain(range, bold), href_(boost::begin(href), boost::end(href)) {
  }
  virtual ~Anchor() {}

  /*! @brief return a cursor type appropriated to the anchor text element.
   *
   * @return the cursor type for the anchor.
   */
  virtual Gdk::CursorType get_cursor_type() const;

  /*! @brief return the href.
   *
   * @return the href.
   */
  Glib::ustring get_href() const { return href_; }

protected:
  virtual void do_draw_glyphs(text_view::DrawingSet&, const Pango::Item&,
      const Pango::GlyphString&, double x, double y,
      bool in_selection) const;

  void do_draw_underline(text_view::DrawingSet&,
      const Glib::RefPtr<const Gdk::GC>&, double width, double x, double y) const;

private:
  virtual Anchor* do_clone() const { return new Anchor(*this); }

protected:
  /*! @brief hyper reference */
  const Glib::ustring href_;
};


} // namespace text_element

} // namespace dialektos


#endif
