/*
 * Copyright (C) 2009 by Aiwota Programmer
 * aiwotaprog@tetteke.tk
 *
 * This file is part of Dialektos.
 *
 * Dialektos is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Dialektos is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Dialektos.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "text_element_anchor.hxx"

#include <glibmm/refptr.h>
#include <gdkmm/cursor.h>
#include <gdkmm/gc.h>
#include <gtkmm/enums.h>

#include "text_view_drawing_set.hxx"


namespace dialektos {

namespace text_element {

Gdk::CursorType Anchor::get_cursor_type() const {
  return Gdk::HAND2;
}

void Anchor::do_draw_glyphs(text_view::DrawingSet& set,
    const Pango::Item& item, const Pango::GlyphString& glyphs,
    double x, double y, bool in_selection) const {

  Glib::RefPtr<const Gdk::GC> gc = set.style->get_text_gc(
      in_selection ? Gtk::STATE_SELECTED : Gtk::STATE_NORMAL);

  set.window->draw_glyphs(gc, item.get_analysis().get_font(),
      x, y - set.adj_value + get_metrics().get_ascent() / Pango::SCALE, glyphs);

  do_draw_underline(set, gc, double(glyphs.get_width()) / Pango::SCALE, x, y);
}

void Anchor::do_draw_underline(text_view::DrawingSet& set,
    const Glib::RefPtr<const Gdk::GC>& gc,
    double width, double x, double y) const {

  const int underline = get_metrics().get_underline_position();
  const int underline_y = y - set.adj_value +
      double(get_metrics().get_ascent() - underline) / Pango::SCALE;

  set.window->draw_line(gc, std::ceil(x), underline_y,
      std::ceil(x + width), underline_y);
}


} // namespace text_element

} // namespace dialektos
