/*
 * Copyright (C) 2009 by Aiwota Programmer
 * aiwotaprog@tetteke.tk
 *
 * This file is part of Dialektos.
 *
 * Dialektos is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Dialektos is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Dialektos.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef SCROLLED_CONTAINER_HXX
#define SCROLLED_CONTAINER_HXX

#include <gtkmm/scrollbar.h>
#include <gtkmm/adjustment.h>
#include <gtkmm/box.h>
#include <gtkmm/widget.h>

namespace dialektos {

class Scrollbar: public Gtk::VScrollbar {
public:
  explicit Scrollbar(Gtk::Adjustment& adjustment);

  void on_adjustment_changed();
  void set_adjustment(Gtk::Adjustment& adjustment);
};


class ScrolledContainer: public Gtk::HBox {
public:
  explicit ScrolledContainer(Gtk::Adjustment& adjustment) :
    Gtk::HBox(), scrollbar_(adjustment) {
    pack_start(scrollbar_, false, false);
  }
  void add(Gtk::Widget&);
  bool on_child_scroll_event(GdkEventScroll*);
  void set_adjustment(Gtk::Adjustment& adjustment);
private:
  Scrollbar scrollbar_;
};

} // namespace dialektos

#endif
