/*
 * Copyright (C) 2009 by Aiwota Programmer
 * aiwotaprog@tetteke.tk
 *
 * This file is part of Dialektos.
 *
 * Dialektos is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Dialektos is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Dialektos.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "scrolled_container.hxx"

#include <gtkmm/widget.h>
#include <gtkmm/adjustment.h>


namespace dialektos {


Scrollbar::Scrollbar(Gtk::Adjustment& adjustment): VScrollbar(adjustment) {
  set_no_show_all(true);

  adjustment.signal_changed().connect(
      sigc::mem_fun(*this, &Scrollbar::on_adjustment_changed));
}

void Scrollbar::on_adjustment_changed() {
  if (get_adjustment()->get_upper() <= get_adjustment()->get_page_size())
    hide();
  else
    show();
}

void Scrollbar::set_adjustment(Gtk::Adjustment& adjustment) {
  Gtk::VScrollbar::set_adjustment(adjustment);
  adjustment.signal_changed().connect(
      sigc::mem_fun(*this, &Scrollbar::on_adjustment_changed));
}


void ScrolledContainer::add(Gtk::Widget& child) {
  child.add_events(Gdk::SCROLL_MASK);
  child.signal_scroll_event().connect(
      sigc::mem_fun(*this, &ScrolledContainer::on_child_scroll_event));
  pack_start(child, true, true);
  reorder_child(child, 0);
}

bool ScrolledContainer::on_child_scroll_event(GdkEventScroll* event) {
  if (scrollbar_.is_realized()) scrollbar_.event((GdkEvent*)(event));
  return true;
}

void ScrolledContainer::set_adjustment(Gtk::Adjustment& adjustment) {
  scrollbar_.set_adjustment(adjustment);
}

} // namespace dialektos
