/*
 * Copyright (C) 2009 by Aiwota Programmer
 * aiwotaprog@tetteke.tk
 *
 * This file is part of Dialektos.
 *
 * Dialektos is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Dialektos is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Dialektos.  If not, see <http://www.gnu.org/licenses/>.
 */


#ifndef MISC_HXX
#define MISC_HXX

#include <boost/filesystem.hpp>
#include <iostream>


namespace dialektos {

namespace misc {


/*! @brief creates directories recursively with try and catch. */
inline bool create_directories(const boost::filesystem::path& path) {
  try {
    boost::filesystem::create_directories(path);
  } catch (const boost::filesystem::filesystem_error& e) {
    std::cerr << e.what() << std::endl;
    return false;
  }
  return true;
}


} // namespace misc

} // namespace dialektos


#endif
