/*
 * Copyright (C) 2009 by Aiwota Programmer
 * aiwotaprog@tetteke.tk
 *
 * This file is part of Dialektos.
 *
 * Dialektos is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Dialektos is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Dialektos.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glibmm/signalproxy.h>
#include <glibmm/thread.h>
#include <gtkmm/main.h>
#include <sigc++/functors/ptr_fun.h>
#include "uri_opener.hxx"
#include "application_window.hxx"


/*! @brief namespace for dialektos */
namespace dialektos {}


bool window() {

  dialektos::ApplicationWindow::load();

  return false;
}

int main(int args, char** argv) {

  Gtk::Main kit(args ,argv);
  Glib::thread_init();

  Glib::signal_idle().connect(sigc::ptr_fun(window));

  Gtk::Main::run();

  return 0;
}
