/*
 * Copyright (C) 2009 by Aiwota Programmer
 * aiwotaprog@tetteke.tk
 *
 * This file is part of Dialektos.
 *
 * Dialektos is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Dialektos is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Dialektos.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef HTTP_STATUS_LINE_HXX
#define HTTP_STATUS_LINE_HXX

#include <string>


namespace dialektos {

namespace http {


struct StatusLine {
  StatusLine() : version_(), code_(0), message_(), line_() {}
  StatusLine(const std::string& version, int code, const std::string& message,
      const std::string& line) :
    version_(version), code_(code), message_(message), line_(line) {}

  const std::string& get_version() const { return version_; }
  int get_code() const { return code_; }
  const std::string& get_message() const { return message_; }
  const std::string& get_line() const { return line_; }

private:
  const std::string version_;
  int code_;
  const std::string message_;
  const std::string line_;
};


} // namespace http

} // namespace dialektos



#endif
