/*
 * Copyright (C) 2009 by Aiwota Programmer
 * aiwotaprog@tetteke.tk
 *
 * This file is part of Dialektos.
 *
 * Dialektos is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Dialektos is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Dialektos.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef HTTP_HEADER_HXX
#define HTTP_HEADER_HXX

#include <string>
#include <map>


namespace dialektos {

namespace http {


struct Header {
  typedef std::map<std::string, std::string> MapType;
  typedef MapType::const_iterator const_iterator;
  typedef MapType::value_type value_type;

  Header();
  Header(const Header& rhs);
  ~Header();

  const_iterator begin() const { return map_.begin(); }
  const_iterator end() const { return map_.end(); }

  void set_header_from_line(const std::string&);

  void set_host(const std::string&);
  void set_if_modified_since(const std::string&);
  void set_if_none_match(const std::string&);
  void set_range(int);

  std::string get_host() const;
  std::string get_last_modified() const;
  std::string get_etag() const;
  std::string get_range() const;

private:
  void set_header(const std::string&, const std::string&);
  std::string get_header(const std::string&) const;

  MapType map_;
};


} // namespace http

} // namespace dialektos


#endif
