/*
 * Copyright (C) 2009 by Aiwota Programmer
 * aiwotaprog@tetteke.tk
 *
 * This file is part of Dialektos.
 *
 * Dialektos is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Dialektos is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Dialektos.  If not, see <http://www.gnu.org/licenses/>.
 */


#ifndef HTTP_GET_HXX
#define HTTP_GET_HXX

#include <sigc++/signal.h>
#include <glibmm/dispatcher.h>
#include <boost/thread/mutex.hpp>
#include <boost/thread/thread.hpp>
#include <boost/scoped_ptr.hpp>
#include <boost/asio/io_service.hpp>
#include <string>
#include "http_header.hxx"
#include "http_response.hxx"


namespace dialektos {

namespace http {


struct GetInThread {
  typedef sigc::signal<void, bool> SignalEndType;

  GetInThread(const std::string& uri, const Header& request_header);
  ~GetInThread();
  void cancel();
  bool run();

  void operator()();

  SignalEndType& signal_end() { return signal_end_; }

  const std::string& get_uri() const { return uri_;}
  const Header& get_request_header() const { return request_header_; }
  const Response& get_response() const { return *response_; }
  boost::system::error_code get_error() const { return err_; }
private:
  void on_end_dispather();

  Glib::Dispatcher dispatcher_;
  SignalEndType signal_end_;
  boost::mutex mutex_;
  bool cancel_;
  boost::scoped_ptr<boost::thread> thread_;

  const std::string uri_;
  Header request_header_;
  boost::scoped_ptr<Response> response_;
  boost::system::error_code err_;
  boost::scoped_ptr<boost::asio::io_service> io_service_;
};

} // namespace http

} // namespace dialektos


#endif
