/*
 * Copyright (C) 2009 by Aiwota Programmer
 * aiwotaprog@tetteke.tk
 *
 * This file is part of Dialektos.
 *
 * Dialektos is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Dialektos is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Dialektos.  If not, see <http://www.gnu.org/licenses/>.
 */


#include "http_get.hxx"

#include <sigc++/functors/mem_fun.h>
#include <boost/asio/io_service.hpp>
#include <boost/thread/locks.hpp>
#include <boost/thread/thread.hpp>
#include <boost/function.hpp>
#include <string>
#include "http_client.hxx"


namespace dialektos {

namespace http {


GetInThread::GetInThread(const std::string& uri,
    const Header& request_header) :
      dispatcher_(), signal_end_(),
      mutex_(), cancel_(false), thread_(),
      uri_(uri), request_header_(request_header), response_(), err_(),
      io_service_() {
  dispatcher_.connect(sigc::mem_fun(*this, &GetInThread::on_end_dispather));
}

GetInThread::~GetInThread() {
  if (thread_) {
    cancel();
    thread_->join();
  }
}

void GetInThread::cancel() {
  boost::mutex::scoped_lock lock(mutex_);
  if (io_service_) {
    io_service_->stop();
    cancel_ = true;
  }
}

bool GetInThread::run() {
  if (thread_) return false;
  thread_.reset(new boost::thread(boost::ref(*this)));
  return true;
}

namespace {
struct ScopeExit {
  ScopeExit(boost::function<void ()> f) : function(f) {}
  ~ScopeExit() { function(); }
  boost::function<void ()> function;
};
}

void GetInThread::operator()() {
  ScopeExit scope_exit(boost::ref(dispatcher_));
  {
    boost::mutex::scoped_lock lock(mutex_);
    io_service_.reset(new boost::asio::io_service);
  }
  AsyncClient client(*io_service_, uri_, request_header_);
  io_service_->run();
  response_.reset(new Response(client.get_response()));
  err_ = client.get_error();
}

void GetInThread::on_end_dispather() {
  thread_.reset(0);
  io_service_.reset(0);
  signal_end_(!cancel_);
}


} // namespace http

} // namespace dialektos
