/*
 * Copyright (C) 2009 by Aiwota Programmer
 * aiwotaprog@tetteke.tk
 *
 * This file is part of Dialektos.
 *
 * Dialektos is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Dialektos is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Dialektos.  If not, see <http://www.gnu.org/licenses/>.
 */


#include "http_date.hxx"

#include <boost/xpressive/xpressive.hpp>
#include <boost/format.hpp>
#include <boost/date_time/posix_time/posix_time.hpp>
#include <sstream>
#include <string>
#include <map>


namespace dialektos {

boost::posix_time::ptime rfc1123_to_ptime(const std::string& rfc1123) {
  using namespace boost::xpressive;

  std::map<std::string, std::string> months;
  months["Jan"] = "01";
  months["Feb"] = "02";
  months["Mar"] = "03";
  months["Apr"] = "04";
  months["May"] = "05";
  months["Jun"] = "06";
  months["Jul"] = "07";
  months["Aug"] = "08";
  months["Sep"] = "09";
  months["Oct"] = "10";
  months["Nov"] = "11";
  months["Dec"] = "12";

  // Sun, 01 Jan 1999 09:59:59 GMT   RFC1123
  const sregex regex = (s1=-repeat<3>(alpha)) >> ", "
  >> (s2=-repeat<2>(_d)) >> ' '
  >> (s3=-repeat<3>(alpha)) >> ' '
  >> (s4=-repeat<4>(_d)) >> ' '
  >> (s5=-repeat<2>(_d)) >> ':'
  >> (s6=-repeat<2>(_d)) >> ':'
  >> (s7=-repeat<2>(_d)) >> ' '
  >> "GMT";

  smatch what;
  if (!regex_match(rfc1123, what, regex)) throw HTTPDateError();

//  const std::string day_of_week = what[1];
  const std::string day = what[2];
  const std::string _month = what[3];
  const std::string year = what[4];
  const std::string hour = what[5];
  const std::string min = what[6];
  const std::string sec = what[7];

  if (months.find(_month) == months.end()) throw HTTPDateError();

  const std::string month = months[_month];

  std::stringstream ss;
  ss << boost::format("%1%-%2%-%3% %4%:%5%:%6%")
  % year % month % day % hour % min % sec << std::flush;

  try {
    boost::posix_time::ptime ptime =
      boost::posix_time::time_from_string(ss.str());
    return ptime;
  } catch (const std::out_of_range& e) {
    throw HTTPDateError();
  }
}



} // namespace dialektos
