/*
 * Copyright (C) 2009 by Aiwota Programmer
 * aiwotaprog@tetteke.tk
 *
 * This file is part of Dialektos.
 *
 * Dialektos is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Dialektos is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Dialektos.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef HISTORY_ITEM_HXX
#define HISTORY_ITEM_HXX

#include <boost/serialization/access.hpp>
#include <boost/serialization/nvp.hpp>
#include <boost/date_time/posix_time/posix_time.hpp>
#include <string>


namespace dialektos {

namespace history {


struct Item {
  typedef std::string UriType;
  typedef std::string NameType;
  typedef boost::posix_time::ptime TimeType;

  UriType uri_;
  NameType name_;
  TimeType time_;
private:
  friend class boost::serialization::access;
  BOOST_SERIALIZATION_SPLIT_MEMBER();

  template <typename ArchiveType>
  void  load(ArchiveType& ar, const unsigned int version) {
    ar & boost::serialization::make_nvp("Name", name_);
    ar & boost::serialization::make_nvp("URI", uri_);
    std::string iso;
    ar & boost::serialization::make_nvp("Time", iso);
    time_ = boost::posix_time::from_iso_string(iso);
  }
  template <typename ArchiveType>
  void save(ArchiveType& ar, const unsigned int version) const {
    ar & boost::serialization::make_nvp("Name", name_);
    ar & boost::serialization::make_nvp("URI", uri_);
    const std::string iso = boost::posix_time::to_iso_string(time_);
    ar & boost::serialization::make_nvp("Time", iso);
  }

};


} // namespace history

} // namespace dialektos

#endif
