/*
 * Copyright (C) 2009 by Aiwota Programmer
 * aiwotaprog@tetteke.tk
 *
 * This file is part of Dialektos.
 *
 * Dialektos is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Dialektos is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Dialektos.  If not, see <http://www.gnu.org/licenses/>.
 */


#ifndef CONVERT_CODE_HXX
#define CONVERT_CODE_HXX

#include <string>
#include "cp932_table.hxx"


namespace dialektos {

namespace convert {


struct CP932toUTF8 : CP932Table {
  CP932toUTF8();
  void bmp_to_buffer(unsigned short bmp);
  void cp932_to_buffer(unsigned char ch);
  void cp932_to_buffer(unsigned char ch1, unsigned char ch2);
  void unknown_to_buffer(unsigned char ch);
  void unknown_to_buffer(unsigned char ch1, unsigned char ch2);
  std::string operator()(const std::string& input);

  std::string buffer_;
  unsigned char lead_;
};

std::string cp932(const std::string& input);


} // namespace convert

} // namespace dialektos


#endif
