/*
 * Copyright (C) 2009 by Aiwota Programmer
 * aiwotaprog@tetteke.tk
 *
 * This file is part of Dialektos.
 *
 * Dialektos is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Dialektos is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Dialektos.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef BOARD_WINDOW_STATE_HXX
#define BOARD_WINDOW_STATE_HXX

#include <boost/serialization/access.hpp>
#include <boost/serialization/nvp.hpp>
#include <boost/serialization/map.hpp>
#include <boost/serialization/string.hpp>
#include <boost/filesystem/path.hpp>
#include <map>
#include <string>


namespace dialektos {


struct BoardWindowState {
  struct ColumnInfo {
    ColumnInfo() : width(0), order(-1) {}
    int width;
    unsigned int order;
  private:
    friend class boost::serialization::access;
    template <typename ArchiveType>
    void serialize(ArchiveType& ar, const unsigned int version) {
      ar & boost::serialization::make_nvp("ColumnWidth", width);
      ar & boost::serialization::make_nvp("ColumnOrder", order);
    }
  };

  struct SortInfo {
    SortInfo() : column("No."), ascendant(true) {}
    std::string column;
    bool ascendant;
  private:
    friend class boost::serialization::access;
    template <typename ArchiveType>
    void serialize(ArchiveType& ar, const unsigned int version) {
      ar & boost::serialization::make_nvp("SortColumn", column);
      ar & boost::serialization::make_nvp("SortOrder", ascendant);
    }
  };

  BoardWindowState();

  int width;
  int height;
  bool menubar;
  bool toolbar;
  bool statusbar;
  std::map<std::string, ColumnInfo> columns;
  SortInfo sort;

  void from_xml(const boost::filesystem::path& xml);
  void to_xml(const boost::filesystem::path& xml);

private:
  friend class boost::serialization::access;
  template <typename ArchiveType>
  void serialize(ArchiveType& ar, const unsigned int version) {
    ar & boost::serialization::make_nvp("WindowWidth", width);
    ar & boost::serialization::make_nvp("WindowHeight", height);
    ar & boost::serialization::make_nvp("MenubarVisible", menubar);
    ar & boost::serialization::make_nvp("ToolbarVisible", toolbar);
    ar & boost::serialization::make_nvp("StatusbarVisible", statusbar);
    ar & boost::serialization::make_nvp("Columns", columns);
    ar & boost::serialization::make_nvp("SortColumn", sort);
  }

};


} // namespace dialektos


#endif
