/*
 * Copyright (C) 2010 by Aiwota Programmer
 * aiwotaprog@tetteke.tk
 *
 * This file is part of Dialektos.
 *
 * Dialektos is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Dialektos is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Dialektos.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "bbs_detail_yy.hxx"

#include <boost/filesystem.hpp>
#include <boost/xpressive/xpressive.hpp>
#include <string>
#include <iostream>

namespace dialektos {

namespace bbs_detail {


const std::string YY::bbs_name = "yy";

YY* YY::judge(const std::string& uri) {
  if (YY* bbs = judge_thread(uri)) return bbs;
  if (YY* bbs = judge_board(uri)) return bbs;
  return 0;
}

YY* YY::judge_thread(const std::string& uri) {
  using namespace boost::xpressive;

  sregex regex = "http://" >> (s1=as_xpr("yy") >> repeat<2,2>(_d)
  >> (as_xpr(".kakiko.com")|as_xpr(".60.kg")))
  >> as_xpr("/test/read.cgi/")
  >> (s2=+_w)
  >> '/' >> (s3=+_d) >> '/' >> -*(_d|'-');

  smatch what;
  if (!regex_match(uri, what, regex))
    return 0;

  const std::string host = what[1];
  const std::string board = what[2];
  const std::string thread = what[3];

  return new YY(uri, host, board, thread);
}

YY* YY::judge_board(const std::string& uri) {
  using namespace boost::xpressive;

  sregex regex = "http://" >> (s1=as_xpr("yy") >> repeat<2,2>(_d)
  >> (as_xpr(".kakiko.com")|as_xpr(".60.kg"))) >> as_xpr('/')
  >> (s2=+_w) >> '/' >> -*_w;

  smatch what;
  if (!regex_match(uri, what, regex))
    return 0;

  const std::string host = what[1];
  const std::string board = what[2];

  return new YY(uri, host, board, "");
}


YY::YY(const std::string& uri, const std::string& host,
    const std::string& board, const std::string& thread) :
      Base(uri, host, board, thread) {}

YY::YY(const YY& rhs) : Base(rhs) {}

YY::~YY() {}

YY* YY::do_clone() const {
  return new YY(*this);
}

const std::string& YY::get_bbs_name() const {
  return bbs_name;
}

} // namespace bbs_detail

} // namespace dialektos
