/*
 * Copyright (C) 2009 by Aiwota Programmer
 * aiwotaprog@tetteke.tk
 *
 * This file is part of Dialektos.
 *
 * Dialektos is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Dialektos is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Dialektos.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef BBS_DETAIL_BASE_HXX
#define BBS_DETAIL_BASE_HXX

#include <string>
#include <vector>
#include "board_subject_item.hxx"
#include "http_header.hxx"


namespace dialektos {

namespace text_view {
  class Layoutable;
}

namespace bbs_detail {


class Base {
public:
  Base(const std::string& uri, const std::string& host,
      const std::string& board, const std::string& thread);
  Base* clone() const;
  virtual ~Base();
  virtual std::string get_board_dir_path() const;
  virtual std::string get_thread_file_path() const;
  virtual std::string get_thread_idx_path() const;
  virtual std::string get_thread_state_path() const;
  virtual std::string get_thread_dat_uri() const;
  virtual std::string get_thread_uri() const;
  virtual std::string get_another_thread_uri(const std::string& thread) const;
  virtual std::string get_board_subject_path() const;
  virtual std::string get_board_state_path() const;
  virtual std::string get_board_subject_uri() const;
  virtual std::string get_board_uri() const;
  virtual std::string get_board_subject_idx_path() const;
  virtual std::string get_board_idx_dir_path() const;
  virtual std::string get_board_id() const;
  virtual http::Header get_board_subject_request_header() const;
  virtual http::Header get_thread_dat_request_header() const;
  virtual std::string get_title_from_string(const std::string& dat) const;
  virtual bool belongs_to(const Base& rhs) const;
  virtual std::string get_thread_id() const;

  virtual const std::string& get_encoding() const;

  virtual void load_thread(text_view::Layoutable& output) const;
  virtual void load_thread_from_string(
      const std::string& dat, text_view::Layoutable& output) const;
  virtual void load_subject(std::vector<SubjectItem>& output) const;
  virtual void load_subject_from_string(
      const std::string&, std::vector<SubjectItem>& output) const;

  bool is_board() const;
  bool is_thread() const;
//  static Base* judge(const std::string& uri);

  bool operator==(const bbs_detail::Base& rhs) const;

protected:
  explicit Base(const Base& rhs);
private:
  virtual Base* do_clone() const;

protected:
  virtual const std::string& get_bbs_name() const;

  const std::string uri_;
  const std::string host_;
  const std::string board_;
  const std::string thread_;

  static const std::string bbs_name;
  static const std::string encoding;
};


} // namespace bbs_detail

} // namespace dialektos

#endif
