/*
 * Copyright (C) 2009 by Aiwota Programmer
 * aiwotaprog@tetteke.tk
 *
 * This file is part of Dialektos.
 *
 * Dialektos is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Dialektos is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Dialektos.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "bbs_detail_2ch.hxx"

#include <boost/filesystem.hpp>
#include <boost/xpressive/xpressive.hpp>
#include <string>
#include <iostream>

namespace dialektos {

namespace bbs_detail {


const std::string CH2::bbs_name = "2ch";

CH2* CH2::judge(const std::string& uri) {
  if (CH2* bbs = judge_thread(uri)) return bbs;
  if (CH2* bbs = judge_board(uri)) return bbs;
  return 0;
}

CH2* CH2::judge_thread(const std::string& uri) {
  using namespace boost::xpressive;

  sregex regex = "http://" >> (s1=+(_w|'-') >> ".2ch.net")
  >> as_xpr("/test/read.cgi/")
  >> (s2=+_w)
  >> '/' >> (s3=+_d) >> '/' >> -*(_d|'-');

  smatch what;
  if (!regex_match(uri, what, regex))
    return 0;

  const std::string host = what[1];
  const std::string board = what[2];
  const std::string thread = what[3];

  return new CH2(uri, host, board, thread);
}

CH2* CH2::judge_board(const std::string& uri) {
  using namespace boost::xpressive;

  sregex regex = "http://" >> (s1=+(_w|'-') >> ".2ch.net") >> as_xpr('/')
  >> (s2=+_w) >> '/' >> -*_w;

  smatch what;
  if (!regex_match(uri, what, regex))
    return 0;

  const std::string host = what[1];
  const std::string board = what[2];

  return new CH2(uri, host, board, "");
}


CH2::CH2(const std::string& uri, const std::string& host,
    const std::string& board, const std::string& thread) :
      Base(uri, host, board, thread) {}

CH2::CH2(const CH2& rhs) : Base(rhs) {}

CH2::~CH2() {}

CH2* CH2::do_clone() const {
  return new CH2(*this);
}

std::string CH2::get_board_dir_path() const {
  std::string homedir = std::getenv("HOME");
  boost::filesystem::path dir(homedir);
  dir = dir / ".dialektos" / "logs" / get_bbs_name() / board_;
  return dir.file_string();
}

const std::string& CH2::get_bbs_name() const {
  return bbs_name;
}

} // namespace bbs_detail

} // namespace dialektos
