/*
 * Copyright (C) 2009 by Aiwota Programmer
 * aiwotaprog@tetteke.tk
 *
 * This file is part of Dialektos.
 *
 * Dialektos is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Dialektos is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Dialektos.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef APPLICATION_FRAMEWORK_HXX
#define APPLICATION_FRAMEWORK_HXX

#include <glibmm/refptr.h>
#include <gtkmm/widget.h>
#include <gtkmm/box.h>
#include <gtkmm/statusbar.h>
#include <gtkmm/uimanager.h>
#include <gtkmm/actiongroup.h>
#include <gtkmm/menu.h>
#include <gtkmm/menuitem.h>
#include "application_window.hxx"


namespace dialektos {


class ApplicationFrameWork: public ApplicationWindow {
  typedef ApplicationFrameWork ThisClass;
public:
  ApplicationFrameWork();
  virtual ~ApplicationFrameWork();
  void add(Gtk::Widget& child);
protected:
  void build_menubar();
  virtual void on_action_file_quit();
  virtual void on_action_file_close();
  virtual void on_action_edit_copy();
  virtual void on_action_view_refresh();
  virtual void on_action_view_stop();
  virtual void on_action_view_menubar();
  virtual void on_action_view_toolbar();
  virtual void on_action_view_statusbar();
  virtual void on_action_bookmark_show();

  virtual void on_child_button_press(GdkEventButton*);

  void on_history_menu_item_activate(const std::string&);
  void on_history_menu_items_activate(const std::vector<std::string>&) const;
  void on_history_menu_items_open_close_activate(
      const std::vector<std::string>&) const;
  void set_history_menus();

  Gtk::VBox vbox_;
  Gtk::Statusbar statusbar_;
  Glib::RefPtr<Gtk::UIManager> ui_manager_;
  Glib::RefPtr<Gtk::ActionGroup> action_group_;
  Gtk::Widget* menubar_;
  Gtk::Widget* toolbar_;
  Gtk::Menu* popupmenu_;
  Gtk::MenuItem* history_menu_;
};


} // namespace dialektos

#endif
