// XNuaLuaParser.h

#pragma once

using namespace System;
using namespace System::IO;

// forward decl Lua proto
struct Proto;
struct lua_State;

namespace XNua
{
	namespace LuaParser 
	{

		// this is a simple wrapper for the intermediate object between
		// the lua read and write phase. By exposing it, it allows you
		// to do parse only passes, handy for syntax error checking in
		// editors and the like
		public ref class ProtoWrapper
		{
		public:
			ProtoWrapper( Proto* proto )
			{
				Proto = proto;
			}
			property Proto* Proto;
		};

		public ref class ParseException : public System::Exception
		{
		public:
			ParseException( String^ source, String^ lineNum, String^ messageText )
			{
				Source = source;
				LineNum = lineNum;
				MessageText = messageText;
			}

			property String^ LineNum;
			property String^ MessageText;
		};

		public ref class Parser
		{
		public:
			// default Parser has its own Lua state
			Parser();

			// create with the provided lua state
			Parser( lua_State* l );

			// cleanup
			~Parser();

			/// parses the text in the string returning a ProtoWrapper
			/// or throwing an ParseException if there is a syntax error
			/// the filename is used by the debugger, if there is not real file
			/// is default to Nothing, cos source level debugging is not possible
			ProtoWrapper^ ParseString( String^ text, String^ filename ); 

			/// helper to Parse String that parses a file off disk
			ProtoWrapper^ ParseFile( String^ filename );

			/// Write prototype, this outputs Lua bytecode of the proto passed in
			void WriteByteCode( ProtoWrapper^ proto, Stream^ output );

			/// takes a stream of byte code and produces and IL assembly in the
			/// full file path passed in
			void ByteCodeToIL( Stream^ input, String^ filepath );

		private:
			bool			ownState;
			lua_State*		L;
		};
	}
}
