/*
 * 
 * XNua 0.1 Based Massively on Lua2IL 0.5
 * Lua2IL 0.5.0
 * LuaLoad.cs - Loader for Lua compiled chunks
 * Copyright 2003-2005 Fabio Mascarenhas
 *                2007 Dean Calver
 * 
 */

using System;
using System.Collections.Generic;
using System.Text;

namespace XNua
{
    public enum LuaTypes
    {
        LUA_TNONE = -1,
        LUA_TNIL = 0,
        LUA_TNUMBER = 3,
        LUA_TSTRING = 4,
        LUA_TBOOLEAN = 1,
        LUA_TTABLE = 5,
        LUA_TFUNCTION = 6,
        LUA_TUSERDATA = 7,
        LUA_TLIGHTUSERDATA = 2
    }

    public class LuaState
    {
        public static readonly int MAX_LOCAL_STACK = 250;
        public static readonly int MIN_STACK = 20;
        public static readonly int LFIELDS_PER_FLUSH = 32;

        static readonly int BASIC_STACK_SIZE = 2 * MIN_STACK;
        static readonly int EXTRA_STACK = 5;

        public LuaStack Stack;
        public LuaReference Globals;
        public UpValue OpenUpvalues;

        public Semaphore YieldHandle = null;
        public Semaphore ResumeHandle = null;
        public int ResumeArgs;

        public LuaState()
        {
            Stack = new LuaStack(BASIC_STACK_SIZE + EXTRA_STACK);
            Globals = new LuaTable();
            OpenUpvalues = null;
            LuaBaseLib.InstallStdLib(this);
        }

        public UpValue FindUpVal(int level)
        {
            level = Stack.Base + level;
            UpValue curr = OpenUpvalues;
            UpValue p, v;
            while ((p = curr) != null && p.Level >= level)
            {
                if (p.Level == level) return p;
                curr = p.Next;
            }
            v = new UpValue(Stack, level);
            v.Next = curr;
            OpenUpvalues = v;
            return v;
        }

        public void CloseUpvalues(int level)
        {
            UpValue upval;
            level += Stack.Base;
            UpValue up = OpenUpvalues;
            while (up != null)
            {
                up = up.Next;
            }
            while ((upval = OpenUpvalues) != null && upval.Level >= level)
            {
                upval.Close();
                OpenUpvalues = upval.Next;
            }
        }

        public void PrintStack()
        {
            Console.Write("Base - " + Stack.Base + " | ");
            for (int i = 0; i < Stack.Top; i++)
            {
                Console.Write(Stack.Values[i].ToString() + " | ");
            }
            Console.WriteLine("Top - " + Stack.Top);
        }
    }

    public struct CallInfo
    {
        public int MaxTop;
        public int LastBase;
        public int NResults;
    }

    public class CompiledPrototype
    {
        public LuaValue[] Constants;
        public int[] LineInfo;
        public string[] Upvalues;
        public string Source;
        public int LineDefined;
        public byte NUpvalues;
        public byte NParams;
        public bool IsVararg;
        public byte MaxStack;
    }

    public class UpValue
    {
        bool open;
        LuaStack stack;
        LuaValue O;
        public int Level;
        public UpValue Next;

        public UpValue(LuaStack stack, int level)
        {
            this.stack = stack;
            this.Level = level;
            open = true;
            Next = null;
        }

        public LuaValue Value
        {
            get
            {
                if (open)
                    return stack.Values[Level];
                else
                    return O;
            }
            set
            {
                if (open)
                    stack.Values[Level] = value;
                else
                    O = value;
            }
        }

        public void Close()
        {
            O = stack.Values[Level];
            open = false;
        }
    }

}
