/*
 * 
 * XNua 0.1 Based Massively on Lua2IL 0.5
 * Lua2IL 0.5.0
 * CodeGen.cs - Code generator for the interface layer
 * Copyright 2003-2005 Fabio Mascarenhas
 *                2007 Dean Calver
 * 
 */
#if LUA2IL_CANEMIT

using System;
using System.Reflection;
using System.Reflection.Emit;
using System.Collections;
using System.Threading;

namespace Lua2IL
{
	class DelegateGenerator 
	{
		private Type delegateType;
		
		public DelegateGenerator(Type delegateType) 
		{
			this.delegateType=delegateType;
		}

		public object getGeneratedDelegate(ref LuaValue val)
		{
			if(val.O.Tag==LuaTypes.LUA_TFUNCTION)
				return CodeGeneration.Instance.GetDelegate(delegateType,(LuaFunction)val.O);
			else
				return val.CLRObject;
		}
	}

	class CodeGeneration
	{
		public static CodeGeneration Instance=new CodeGeneration();

		private Type delegateParent=typeof(LuaDelegate);
		private Hashtable delegateCollection=new Hashtable();

		private AssemblyName assemblyName;
		private AssemblyBuilder newAssembly;
		private ModuleBuilder newModule;
		private int luaClassNumber=1;

		private CodeGeneration() 
		{
			assemblyName=new AssemblyName();
			assemblyName.Name="LuaInterface_generatedcode";
			newAssembly=Thread.GetDomain().DefineDynamicAssembly(
				assemblyName, AssemblyBuilderAccess.Run);
			newModule=newAssembly.DefineDynamicModule("LuaInterface_generatedcode");
		}

		private Type GenerateDelegate(Type delegateType)
		{
			string typeName;
			lock(this) 
			{
				typeName = "LuaGeneratedClass" + luaClassNumber;
				luaClassNumber++;
			}
			// Define a public class in the assembly, called typeName
			TypeBuilder myType=newModule.DefineType(typeName,TypeAttributes.Public,delegateParent);
 
			// Defines the delegate method with the same signature as the
			// Invoke method of delegateType
			MethodInfo invokeMethod=delegateType.GetMethod("Invoke");
			ParameterInfo[] paramInfo=invokeMethod.GetParameters();
			Type[] paramTypes=new Type[paramInfo.Length];
			Type returnType=invokeMethod.ReturnType;

			// Counts out and ref params, for use later
			int nOutParams=0; int nOutAndRefParams=0;
			for(int i=0;i<paramTypes.Length;i++) 
			{
				paramTypes[i]=paramInfo[i].ParameterType;
				if((!paramInfo[i].IsIn) && paramInfo[i].IsOut)
					nOutParams++;
				if(paramTypes[i].IsByRef)
					nOutAndRefParams++;
			}
			int[] refArgs=new int[nOutAndRefParams];

			MethodBuilder delegateMethod=myType.DefineMethod("CallFunction",
				invokeMethod.Attributes,
				returnType,paramTypes);

			// Generates the IL for the method
			ILGenerator generator=delegateMethod.GetILGenerator( );
 
			LocalBuilder argv=generator.DeclareLocal(typeof(object[])); // original arguments
			LocalBuilder inArgs=generator.DeclareLocal(typeof(object[])); // with out-only arguments removed
			LocalBuilder outArgs=generator.DeclareLocal(typeof(int[])); // indexes of out and ref arguments
			LocalBuilder retVal;
			if(!returnType.Equals(typeof(void)))  // return value
				retVal=generator.DeclareLocal(returnType);
			else
				retVal=generator.DeclareLocal(typeof(object));
			// Initializes local variables
			generator.Emit(OpCodes.Ldc_I4,paramTypes.Length);
			generator.Emit(OpCodes.Newarr,typeof(object));
			generator.Emit(OpCodes.Stloc,argv);
			generator.Emit(OpCodes.Ldc_I4,paramTypes.Length-nOutParams);
			generator.Emit(OpCodes.Newarr,typeof(object));
			generator.Emit(OpCodes.Stloc,inArgs);
			generator.Emit(OpCodes.Ldc_I4,nOutAndRefParams);
			generator.Emit(OpCodes.Newarr,typeof(int));
			generator.Emit(OpCodes.Stloc,outArgs);
			// Stores the arguments in the local variables
			for(int iArgs=0,iInArgs=0,iOutArgs=0;iArgs<paramTypes.Length;iArgs++) 
			{
				generator.Emit(OpCodes.Ldloc_0);
				generator.Emit(OpCodes.Ldc_I4,iArgs);
				generator.Emit(OpCodes.Ldarg,iArgs+1);
				if(paramTypes[iArgs].IsByRef)
				{
					if(paramTypes[iArgs].GetElementType().IsValueType)
					{
						generator.Emit(OpCodes.Ldobj,paramTypes[iArgs].GetElementType());
						generator.Emit(OpCodes.Box,paramTypes[iArgs].GetElementType());
					} 
					else generator.Emit(OpCodes.Ldind_Ref);
				}
				else 
				{
					if(paramTypes[iArgs].IsValueType)
						generator.Emit(OpCodes.Box,paramTypes[iArgs]);
				}
				generator.Emit(OpCodes.Stelem_Ref);
				if(paramTypes[iArgs].IsByRef) 
				{
					generator.Emit(OpCodes.Ldloc_2);
					generator.Emit(OpCodes.Ldc_I4,iOutArgs);
					generator.Emit(OpCodes.Ldc_I4,iArgs);
					generator.Emit(OpCodes.Stelem_I4);
					refArgs[iOutArgs]=iArgs;
					iOutArgs++;
				}
				if(paramInfo[iArgs].IsIn || (!paramInfo[iArgs].IsOut)) 
				{
					generator.Emit(OpCodes.Ldloc_1);
					generator.Emit(OpCodes.Ldc_I4,iInArgs);
					generator.Emit(OpCodes.Ldarg,iArgs+1);
					if(paramTypes[iArgs].IsByRef)
					{
						if(paramTypes[iArgs].GetElementType().IsValueType) 
						{
							generator.Emit(OpCodes.Ldobj,paramTypes[iArgs].GetElementType());
							generator.Emit(OpCodes.Box,paramTypes[iArgs].GetElementType());
						}
						else generator.Emit(OpCodes.Ldind_Ref);
					}
					else 
					{
						if(paramTypes[iArgs].IsValueType)
							generator.Emit(OpCodes.Box,paramTypes[iArgs]);
					}
					generator.Emit(OpCodes.Stelem_Ref);
					iInArgs++;
				} 
			}
			// Calls the callFunction method of the base class
			generator.Emit(OpCodes.Ldarg_0);
			generator.Emit(OpCodes.Ldloc,argv);
			generator.Emit(OpCodes.Ldloc,inArgs);
			generator.Emit(OpCodes.Ldloc,outArgs);
			generator.Emit(OpCodes.Call,delegateParent.GetMethod("callFunction"));
			// Stores return value
			if(returnType.Equals(typeof(void))) 
			{
				generator.Emit(OpCodes.Pop);
				generator.Emit(OpCodes.Ldnull);
			}
			else if(returnType.IsValueType) 
			{
				generator.Emit(OpCodes.Unbox,returnType);
				generator.Emit(OpCodes.Ldobj,returnType);
			} 
			else generator.Emit(OpCodes.Castclass,returnType);
			generator.Emit(OpCodes.Stloc,retVal);
			// Stores new value of out and ref params
			for(int i=0;i<refArgs.Length;i++) 
			{
				generator.Emit(OpCodes.Ldarg,refArgs[i]+1);
				generator.Emit(OpCodes.Ldloc,argv);
				generator.Emit(OpCodes.Ldc_I4,refArgs[i]);
				generator.Emit(OpCodes.Ldelem_Ref);
				if(paramTypes[refArgs[i]].GetElementType().IsValueType) 
				{
					generator.Emit(OpCodes.Unbox,paramTypes[refArgs[i]].GetElementType());
					generator.Emit(OpCodes.Ldobj,paramTypes[refArgs[i]].GetElementType());
					generator.Emit(OpCodes.Stobj,paramTypes[refArgs[i]].GetElementType());
				} 
				else 
				{
					generator.Emit(OpCodes.Castclass,paramTypes[refArgs[i]].GetElementType());
					generator.Emit(OpCodes.Stind_Ref);
				}
			}
			// Returns
			if(!returnType.Equals(typeof(void)))
				generator.Emit(OpCodes.Ldloc,retVal);
			generator.Emit(OpCodes.Ret);
  
			// creates the new type
			return myType.CreateType();
		}

		public Delegate GetDelegate(Type delegateType, LuaFunction luaFunc)
		{
			ArrayList returnTypes=new ArrayList();
			Type luaDelegateType;
			if (delegateCollection.Contains(delegateType)) 
			{
				luaDelegateType=(Type)delegateCollection[delegateType];
			} 
			else 
			{
				luaDelegateType=GenerateDelegate(delegateType);
				delegateCollection[delegateType] = luaDelegateType;
			}
			MethodInfo methodInfo=delegateType.GetMethod("Invoke");
			returnTypes.Add(methodInfo.ReturnType);
			foreach(ParameterInfo paramInfo in methodInfo.GetParameters()) 
				if(paramInfo.ParameterType.IsByRef)
					returnTypes.Add(paramInfo.ParameterType);
			LuaDelegate luaDelegate=(LuaDelegate)Activator.CreateInstance(luaDelegateType);
			luaDelegate.function=luaFunc;
			luaDelegate.returnTypes=(Type[])returnTypes.ToArray(typeof(Type));
			return Delegate.CreateDelegate(delegateType,luaDelegate,"CallFunction");
		}
	}
}
#endif
