﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Net;
using Microsoft.Xna.Framework.Storage;
using FrkEffectViewer.GameSystem;
using FrkEffectLib;
using System.IO;
using FrkEffectLibExtention;

namespace WindowsGame1
{
    class GameManager
    {
        private ObjectManager ObjMng;
        private static GameManager GameMng;
        //private CamManager CamMng;
        private Camera Cam;
        private Vector3 CamRot;
        private Stopwatch stopwatch = Stopwatch.StartNew();
        private int frames;
        public float fps;
        public VertexDeclaration vertexDeclaration = null;
        public RenderTarget2D[] renderTarget = new RenderTarget2D[4];
        //public Texture2D BufTex;
        public SpriteBatch spriteBatch;
        public VertexPositionColorTexture[] vertices = new VertexPositionColorTexture[4];
        public int nNowRender;
        BasicEffect basicEffect;
        uint NowEffect = 0;

        //エフェクト生成座標
        Vector3 CreatePos;
        //エフェクト生成座標移動用クォータニオン
        Quaternion CreateQuaternion;

        //生成座標移動タイプ
        public int CreatePointMoveType = 0;
        //拡大倍率
        public float CreateScale = 1.0f;
        //生成座標移動速度
        public float CreatePointMoveSpd = 1.0f;

        //生成点オブジェポインタ
        private CreatePointObj CPObj;

        //生成座標移動タイプデバッグ出力用文字列
        public string[] szCreatePointMoveType = 
        {
            "STOP",
            "Rotation_X",
            "Rotation_Y",
            "Rotation_Z",
            "Rotation_Z and Roll",
            "MOVE_Z",
        };



        FrkLibEffectManager EffectManager;
        FrkLibEffectData PlayData;
        private GameManager()
        {
            CreatePos = new Vector3(0, 0, 0);
            CreateQuaternion = Quaternion.Identity;
            PlayData = null;
            ObjMng = ObjectManager.GetObjectManager();
            nNowRender = 0;
            CamRot = new Vector3(45, 25, 0);
        }
        public RenderTarget2D getRenderTargetBuf()
        {
            return renderTarget[(nNowRender + 1) % 2];
        }
        public bool Init()
        {
            //ランダム初期化処理
            DateTime time = DateTime.UtcNow;
            Rand.Init(time.Millisecond);

            //描画系初期化
            // 頂点データ定義を作成
            vertexDeclaration = new VertexDeclaration(
                GameMain.Grf.GetGraphicsDeviceManager().GraphicsDevice, VertexPositionColorTexture.VertexElements);

            
            //描画系初期化
            GraphicsDevice GrfDev = GameMain.Grf.GetGraphicsDeviceManager().GraphicsDevice;
            basicEffect = new BasicEffect(GrfDev, null);
            PresentationParameters pp = GrfDev.PresentationParameters;
            pp.RenderTargetUsage = RenderTargetUsage.PlatformContents;
            int width = pp.BackBufferWidth;
            int height = pp.BackBufferHeight;
            SurfaceFormat format = pp.BackBufferFormat;
            spriteBatch = new SpriteBatch(GrfDev);
            for (int i = 0; i < 4; i++)
            {
                renderTarget[i] = new RenderTarget2D(GrfDev, width, height, 1, format,RenderTargetUsage.PlatformContents);
                GrfDev.SetRenderTarget(0, renderTarget[i]);
                GrfDev.Clear(Color.Black);
            }
            GrfDev.SetRenderTarget(0, null);
            float fAlpha = 255;
            float sizex = renderTarget[0].Width;
            float sizey = renderTarget[0].Height;
            vertices[0].Position = new Vector3(-sizex, 0, -sizey);
            vertices[1].Position = new Vector3(sizex, 0, -sizey);
            vertices[2].Position = new Vector3(-sizex, 0, sizey);
            vertices[3].Position = new Vector3(sizex, 0, sizey);

            vertices[0].TextureCoordinate.X = 0;
            vertices[0].TextureCoordinate.Y = 0;
            vertices[0].Color = new Color(fAlpha, fAlpha, fAlpha, fAlpha);
            vertices[1].TextureCoordinate.X = 1;
            vertices[1].TextureCoordinate.Y = 0;
            vertices[1].Color = new Color(fAlpha, fAlpha, fAlpha, fAlpha);
            vertices[2].TextureCoordinate.X = 0;
            vertices[2].TextureCoordinate.Y = 1;
            vertices[2].Color = new Color(fAlpha, fAlpha, fAlpha, fAlpha);
            vertices[3].TextureCoordinate.X = 1;
            vertices[3].TextureCoordinate.Y = 1;
            vertices[3].Color = new Color(fAlpha, fAlpha, fAlpha, fAlpha);
            
            //カメラマネージャ初期化 カメラ１生成
            Cam = CamManager.GetCamManager().CreateCamera();
            

            //エフェクトマネージャ初期化
            EffectManager = FrkLibEffectManager.GetInstance();
            EffectManager.Init(null,GrfDev);
            //エフェクトのコンパイルイベントのフック
            FrkLibXnuaManager.NeedCompile += new NeedCompileDelegate(FrkLibXnuaManager_NeedCompile);

            //Lilファイルの優先読み込み設定をオフ
            EffectManager.SetFirstLil(false);

            //グリッド生成
            ObjectManager.GetObjectManager().SetObject(new Grid(), ObjectManager.OBJLISTTYPE.OBJLIST_ALPHA);
            //RGBライン生成
            ObjectManager.GetObjectManager().SetObject(new RGBLine(), ObjectManager.OBJLISTTYPE.OBJLIST_ALPHA);
            //生成点生成
            ObjectManager.GetObjectManager().SetObject(CPObj = new CreatePointObj(), ObjectManager.OBJLISTTYPE.OBJLIST_ALPHA);
            


            //サウンドマネージャー更新テスト
            EffectManager.SetSoundManager(new ExSoundManager());
            //ユーザ定義機能更新テスト
            EffectManager.SetUserProc(new MyLuaProc());

            return false;
        }
        //コンパイル必要イベントの処理
        void FrkLibXnuaManager_NeedCompile(string luaFile)
        {
            EffectCompiler.Compile(luaFile);
        }

        public static GameManager GetGameManager()
        {
            if (GameMng == null)
            {
                GameMng = new GameManager();
            }
            return GameMng;
        }

        //メイン処理
        public bool MainProc(GameTime time)
        {
            #region FPS 計測
           // Double d = TimeSpan.FromSeconds(1);
            if (stopwatch.Elapsed > TimeSpan.FromSeconds(1))
            {
                fps = (float)frames / (float)stopwatch.Elapsed.TotalSeconds;
                stopwatch.Reset();
                stopwatch.Start();
                frames = 0;
            }
            frames++;
            #endregion
            //ゲーム終了判定
            if (GamePad.GetState(PlayerIndex.One).Buttons.Back ==
                ButtonState.Pressed || Keyboard.GetState().IsKeyDown(Keys.Escape))
            {
                return true;
            }
            //エフェクト読み込み
            if (InputManager.IsKeyTrg(Keys.F1))
            {
                
                //OpenFileDialogクラスのインスタンスを作成
                System.Windows.Forms.OpenFileDialog ofd = new System.Windows.Forms.OpenFileDialog();

                //はじめのファイル名を指定する
                //はじめに「ファイル名」で表示される文字列を指定する
                ofd.FileName = "";
                //はじめに表示されるフォルダを指定する
                //指定しない（空の文字列）の時は、現在のディレクトリが表示される
                ofd.InitialDirectory = null;
                //[ファイルの種類]に表示される選択肢を指定する
                //指定しないとすべてのファイルが表示される
                ofd.Filter =
                    "luaファイル(*.lua;*.lil)|*.lua;*.lil";
                //[ファイルの種類]ではじめに
                //「すべてのファイル」が選択されているようにする
                ofd.FilterIndex = 1;
                //タイトルを設定する
                ofd.Title = "開くファイルを選択してください";
                //ダイアログボックスを閉じる前に現在のディレクトリを復元するようにする
                ofd.RestoreDirectory = true;
                //存在しないファイルの名前が指定されたとき警告を表示する
                //デフォルトでTrueなので指定する必要はない
                ofd.CheckFileExists = true;
                //存在しないパスが指定されたとき警告を表示する
                //デフォルトでTrueなので指定する必要はない
                ofd.CheckPathExists = true;

                //ダイアログを表示する
                if (ofd.ShowDialog() == System.Windows.Forms.DialogResult.OK)
                {
                    //OKボタンがクリックされたとき
                    //選択されたファイル名を表示する
                    Console.WriteLine(ofd.FileName);
                    //読み込み
                    string name = ofd.FileName;
                    string root = Path.GetPathRoot(name);
                    string fileName1 = Path.GetFileName(name);//ファイル名（拡張子あり）
                    string fileName2 = Path.GetFileNameWithoutExtension(name);//ファイル名（拡張子なし）
                    string fileDir = Path.GetDirectoryName(name);//フォルダまでのパス
                    string fileExt = Path.GetExtension(name);//拡張子だけ（.を含む）
                    if (fileExt == ".lua")
                    {
                        //luaをコンパイル
                        fileName1 = EffectCompiler.Compile(Path.Combine(fileDir, fileName1));
                        fileName2 = Path.GetFileNameWithoutExtension(fileName1);
                    }
                    PlayData = EffectManager.LoadFrkData(fileDir + "\\" + fileName2);
                }
            }
            //生成：基準点に生成後アクセス無し
            if (InputManager.IsKeyTrg(Keys.D1) || InputManager.IsKeyTrg(Keys.NumPad1))
            {
                if (PlayData != null)
                {
                    NowEffect = 0;
                    //エフェクト生成
                    EffectManager.CreateEffect(PlayData, CreatePos,
                        Vector3.One * CreateScale,
                        CreateQuaternion, Color.White);
                }
            }
            //生成：基準点に生成後アクセスあり
            if (InputManager.IsKeyTrg(Keys.D2) || InputManager.IsKeyTrg(Keys.NumPad2))
            {
                if (PlayData != null)
                {
                    //エフェクト生成
                    NowEffect = EffectManager.CreateEffect(PlayData, CreatePos,
                        Vector3.One * CreateScale,
                        CreateQuaternion, Color.White);
                }
            }

            //エフェクト削除
            if (InputManager.IsKeyTrg(Keys.D0) || InputManager.IsKeyTrg(Keys.NumPad0))
            {
                EffectManager.AllDelete();
            }
            //生成点から生成座標取得
            CreatePos = CPObj.Pos;
            CreateQuaternion = CPObj.Qua;
            //エフェクトの更新
            if (NowEffect != 0)
            {
                FrkLibEffectManager.GetInstance().AccessEffect(NowEffect, CreatePos, Vector3.One * CreateScale, CreateQuaternion, Color.White);
            }
            //生成点にパラメータセット
            CPObj.MoveType = CreatePointMoveType;
            CPObj.MoveSpd = CreatePointMoveSpd;

            //パラメータ設定
            //生成サイズ
            if (InputManager.IsKeyTrg(Keys.W))
            {
                CreateScale += 0.1f;
                if (CreateScale > 2.0f)
                {
                    CreateScale = 2.0f;
                }
            }
            if (InputManager.IsKeyTrg(Keys.Q))
            {
                CreateScale -= 0.1f;
                if (CreateScale < 0.0f)
                {
                    CreateScale = 0.0f;
                }
            }
            //生成点移動方法
            if (InputManager.IsKeyTrg(Keys.S))
            {
                CreatePointMoveType++;
                if (CreatePointMoveType > szCreatePointMoveType.Length - 1)
                {
                    CreatePointMoveType = 0;
                }
            }
            if (InputManager.IsKeyTrg(Keys.A))
            {
                CreatePointMoveType--;
                if (CreatePointMoveType < 0)
                {
                    CreatePointMoveType = szCreatePointMoveType.Length - 1;
                }
            }
            //生成点移動速度
            if (InputManager.IsKeyTrg(Keys.X))
            {
                CreatePointMoveSpd+=0.5f;
                if (CreatePointMoveSpd > 5.0f)
                {
                    CreatePointMoveSpd = 5.0f;
                }
            }
            if (InputManager.IsKeyTrg(Keys.Z))
            {
                CreatePointMoveSpd -= 0.5f;
                if (CreatePointMoveSpd < -5.0f)
                {
                    CreatePointMoveSpd = -5.0f;
                }
            }
            //カメラ回転
            float spd = 0.025f;
            if (InputManager.IsKeyDown(Keys.Right))
            {
                CamRot.X += spd;
            }
            if (InputManager.IsKeyDown(Keys.Left))
            {
                CamRot.X -= spd;
            }
            if (InputManager.IsKeyDown(Keys.Down))
            {
                CamRot.Y += spd;
            }
            if (InputManager.IsKeyDown(Keys.Up))
            {
                CamRot.Y -= spd;
            }

            //カメラ更新
            Vector3 Add = new Vector3(0, 0, 10);
            Quaternion camq = Quaternion.CreateFromYawPitchRoll(CamRot.X, CamRot.Y, CamRot.Z);
            Cam.SetPos(Vector3.Transform(Add,camq));
            Matrix mat = Matrix.CreateFromQuaternion(camq);
            Cam.SetLook(Vector3.Zero, mat.Up);


            //オブジェクトマネージャ更新
            ObjMng.Main();

            //エフェクトマネージャ更新
            Matrix View=Cam.GetMatrix();
            Matrix Proj=Cam.GetProj();
            EffectManager.Update(ref View, ref Proj);
    

            return false;
        }
        public void DrawBegin()
        {
            GraphicsDevice GrfDev = GameMain.Grf.GetGraphicsDeviceManager().GraphicsDevice;
            //GrfDev.SetRenderTarget(0, renderTarget[nNowRender]);
            GrfDev.Clear(Color.Black);
        }
        public void DrawEnd()
        {
            GraphicsDevice GrfDev = GameMain.Grf.GetGraphicsDeviceManager().GraphicsDevice;
            GrfDev.SetRenderTarget(0, null);
            //オブジェクトリスト描画
            ObjMng.Draw();

            //エフェクトマネージャ描画
            EffectManager.Draw();
          

            //GrfDev.SetRenderTarget(0, null);
            //DrawRenderTarget(nNowRender, 255);

            //nNowRender++;
            //nNowRender %= 2;

            InputManager.UpDate();
        }
        private void DrawRenderTarget(int texno,byte alpha)
        {
            GraphicsDevice GrfDev = GameMain.Grf.GetGraphicsDeviceManager().GraphicsDevice;
            GrfDev.RenderState.SourceBlend = Blend.SourceAlpha;
            GrfDev.RenderState.DestinationBlend = Blend.InverseSourceAlpha;
            GrfDev.RenderState.AlphaBlendEnable = true;

            //実画面の描画
            GrfDev.SetRenderTarget(0, null);
            GrfDev.Clear(Color.Black);
            spriteBatch.Begin(SpriteBlendMode.AlphaBlend);

                GrfDev.RenderState.SourceBlend = Blend.SourceAlpha;
                GrfDev.RenderState.DestinationBlend = Blend.InverseSourceAlpha;
                GrfDev.RenderState.AlphaBlendEnable = true;

                spriteBatch.Draw(
                    renderTarget[texno].GetTexture(),
                    new Rectangle(0, 0, renderTarget[0].Width, renderTarget[0].Height),
                    new Color(255, 255, 255, 255)
                    );
            spriteBatch.End();
        }
    }
}
