﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;

namespace FrkEffectLibExtention
{
    public static class EffectCompiler
    {
        /// <summary>
        /// Luaを.lilにコンパイル
        /// </summary>
        /// <param name="path">.luaファイル</param>
        /// <returns>.lilファイル</returns>
        public static string Compile(string path)
        {
            string dir = Path.GetDirectoryName(path);
            string file = Path.GetFileNameWithoutExtension(path);
            string luaFile = path;
            string outpath = Path.Combine(dir, file + ".lil");
            if (File.Exists(outpath))
                File.Delete(outpath);
            
            // コンパイル＆.lil 作成
            XNua.LuaParser.Parser parser = new XNua.LuaParser.Parser();
            XNua.LuaParser.ProtoWrapper proto = parser.ParseFile(luaFile);
            System.IO.MemoryStream memStream = new System.IO.MemoryStream(proto.ToString().Length);
            parser.WriteByteCode(proto, memStream);
            memStream.Position = 0;
            parser.ByteCodeToIL(memStream, outpath);
            return outpath;
        }
    }
}
