﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework;
using System.IO;
using Microsoft.Xna.Framework.Graphics;
using System.Collections;

//エフェクトオブジェクト基幹クラス
//基本の行動を取る
//描画なし

namespace FrkEffectLib.Primitive
{
    public class FrkLibEffectObj
    {
        //コンストラクタ
        public FrkLibEffectObj()
        {
            //ベースデータ作成
            Param = new EffectParam(null);
            CreateParam = new EffectParam(Param);
        }
        //デストラクタ
        ~FrkLibEffectObj()
        {
            //何もしない
        }
        //エフェクトオブジェ共通初期化処理
        public void Init(FrkLibEffectData data,uint id)
        {
            DefQua = Quaternion.Identity;
            Mom = null;
            //経過時間設定
            nTime = 0;
            //パラメータ初期化
            Param.Init();
            CreateParam.Init();
            Child.Clear();

            //スクリプトデータ設定
            Param.Data = data;
            if(data != null)
                Param.DataPath = data.Path;
            //ID設定
            ID = id;

            //死亡フラグ
            bKill = false;
        }
        //エフェクトオブジェ固有初期化処理
        public virtual void UniqueInit()
        {
            //何もしない
        }
        //エフェクトオブジェ共通メイン処理
        public bool Main()
        {
            //死亡時も更新する処理
            Matrix.CreateFromQuaternion(ref Param.Qua, out matRot);
            Matrix.CreateTranslation(ref Param.Pos, out matTrans);
            Matrix.CreateScale(ref Param.Scale, out matScale);
            matRotLast = matRot;
            matScaleLast = matScale;
            Matrix mat = Matrix.Identity;

            //ルートの親までのマトリックスを取得
            FrkLibEffectObj p = Mom;
            while (p != null)
            {
                Matrix.Multiply(ref matScaleLast, ref p.matScale, out matScaleLast);
                Matrix.Multiply(ref matRotLast, ref p.matRot, out matRotLast);
                Matrix.Multiply(ref mat, ref p.WorldMat, out mat);

                p = p.Mom;
            }
            {
                Matrix temp;
                Matrix.Multiply(ref matRot, ref matScale, out temp);
                Matrix.Multiply(ref temp, ref matTrans, out WorldMat);

                Matrix.Multiply(ref WorldMat, ref mat, out matLast);
            }
            if (bKill)
                return true;

            //このへん、ref-out関数に書き換えるとちょっと早くなるんだが、面倒なので放置(Wilfrem)

            //座標の更新
            Param.Pos += Param.Vec;
            //角度の更新
            Param.Rot += Param.RotVec;
            Param.Qua = DefQua * Quaternion.CreateFromYawPitchRoll(Param.Rot.X, Param.Rot.Y, Param.Rot.Z);
            //速度の更新
            Param.Vec += Param.AddVec;
            Param.Vec *= Param.MulVec;
            //回転速度の更新
            Param.RotVec += Param.AddRot;
            Param.RotVec *= Param.MulRot;
            //拡大率の更新
            Param.Scale += Param.AddScale;
            Param.Scale *= Param.MulScale;
            //透明度の更新
            Param.Alpha1 += Param.AddAlpha1;
            Param.Alpha1 *= Param.MulAlpha1;
            if (Param.Alpha1 > 1.0f)
                Param.Alpha1 = 1.0f;
            if (Param.Alpha1 < 0.0f)
                Param.Alpha1 = 0.0f;
            Param.Alpha2 += Param.AddAlpha2;
            Param.Alpha2 *= Param.MulAlpha2;
            if (Param.Alpha2 > 1.0f)
                Param.Alpha2 = 1.0f;
            if (Param.Alpha2 < 0.0f)
                Param.Alpha2 = 0.0f;
            //内円比率の更新
            Param.InRatio += Param.AddInRatio;
            Param.InRatio *= Param.MulInRatio;
            //UV座標の更新
            Param.UVPos += Param.UVVec;

            //オブジェ固有メインの実行
            UniqueMain();

            //参照スクリプトがある場合、実行
            if (Param.Data != null)
            {
                bKill = Param.Data.Play(this);
            }

            //生存時間が設定されている場合、削除
            if (Param.LiveTime != 0 && Param.LiveTime <= nTime)
            {
                bKill = true;
            }

            //カメラとの距離を保存
            Vector3 campos = FrkLibEffectManager.GetInstance().GetCamPos();
            fCamLength = (campos - Param.Pos).Length();

            nTime++;
            return false;
        }
        //オブジェ固有メイン処理
        protected virtual void UniqueMain()
        {
            //何もしない
        }
        //描画処理
        public void Draw()
        {
            //生成直後の為、描画無し
            if (nTime == 0)
                return;
            //死んでいた場合、描画無し
            if (bKill)
                return;
            UniqueDraw();
        }
        //オブジェ固有描画処理
        public virtual void UniqueDraw()
        {
            //何もしない
        }
        //子オブジェ作成
        public bool CreateChild()
        {
            FrkLibEffectManager mng = FrkLibEffectManager.GetInstance();
            uint id = mng.CreateEffect(CreateParam,null, CreateParam.Type, Vector3.Zero, Vector3.One, Quaternion.Identity, Color.White);
            FrkLibEffectObj c = mng.GetObj(id);
            if (c == null)
                return false;
            c.GetParam().Copy(CreateParam);
            //親追随フラグによって子にするか新規作成するか決める
            if (CreateParam.ChildFlg)
            {
                Child.Add(c);
                c.SetMom(this);
            }
            else
            {
                //現時点の座標、拡大、回転を継承させる
                c.GetParam().Pos += matLast.Translation;
                c.GetParam().Scale *= Param.Scale;
                c.GetParam().Qua = Quaternion.CreateFromYawPitchRoll(Param.Rot.X, Param.Rot.Y, Param.Rot.Z);
                c.GetParam().Qua *= Param.Qua;
            }
            c.UniqueInit();

            return true;
        }
        //死亡時処理
        public bool End()
        {
            Main();
            //子オブジェが居なくなったらプールに戻る
            if (Child.Count == 0)
            {
                //もし自分に親が居たら、親のリストから自分を抜く
                if (Mom != null)
                {
                    Mom.Child.Remove(this);
                }
                return true;
            }

            return false;
        }
        public int GetEffectType()
        {
            return (int)Param.Type;
        }
        public void SetMom(FrkLibEffectObj p)
        {
            Mom = p;
        }

        //パラメータ取得
        public EffectParam GetParam()
        {
            return Param;
        }
        //生成用パラメータ取得
        public EffectParam GetCreateParam()
        {
            return CreateParam;
        }
        //音再生
        public void PlaySe(string name)
        {
            FrkLibEffectManager.GetInstance().GetSoundManager().PlaySound(name);
        }
        //親のIDを取得
        public uint GetMasterID()
        {
            if (Mom != null)
                return Mom.GetMasterID();
            else
                return ID;
        }
        //メンバ変数

        //エフェクト固有ID
        public uint ID;

        //経過時間
        protected uint nTime;
        public uint GetTime() { return nTime; }
        //死亡フラグ
        protected bool bKill;
        public void SetKill(bool b) { bKill = b; }
        public bool GetKill() { return bKill; }
        //生成パラメーター
        protected EffectParam CreateParam;
        //動作パラメーター
        protected EffectParam Param; 
        //親オブジェ
        protected FrkLibEffectObj Mom;
        //ローカルマトリックス
        public Matrix WorldMat;
        public Matrix matTrans;
        public Matrix matScale;
        public Matrix matRot;
        public Matrix matRotLast;
        public Matrix matScaleLast;
        public Matrix matLast;
        //初期クォータニオン
        public Quaternion DefQua;

        //カメラからの距離（Zソート用）
        public float fCamLength;

        //子オブジェリスト
        protected List<FrkLibEffectObj> Child = new List<FrkLibEffectObj>();


    }
}
