﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework;


namespace FrkEffectLib.Primitive
{
    class FrkLibEffectDisc : FrkLibEffectObj
    {
        public override void UniqueDraw()
        {
            int ver_num = (int)Param.SplitNum * 2;
            VertexPositionColorTexture[] vertices = FrkLibEffectManager.GetInstance().GetVertexPool(ver_num);
            
            Vector3 Add = new Vector3();

            float u = Param.UVPos.X;
            float v = Param.UVPos.Y;
            float us = Param.UVSize.X;
            float vs = Param.UVSize.Y;
            float fMinScale = Param.InRatio;
            float fAlphaOut = Param.Alpha1;
            float fAlphaIn = Param.Alpha2;
            if (fMinScale > 1.0f)
                fMinScale = 1.0f;
            if (fMinScale < 0.0f)
                fMinScale = 0.0f;
            for (int i = 0; i < ver_num; i++)
            {
                float rot = ((float)(i / 2) / (float)((ver_num - 1) / 2)) * 360.0f;
                Add.X = (float)Math.Sin(MathHelper.ToRadians(rot));
                Add.Y = (float)Math.Cos(MathHelper.ToRadians(rot));

                if (i % 2 == 1)
                {
                    //内周
                    vertices[i].Position = Add * fMinScale;
                    vertices[i].TextureCoordinate.X = u + us * ((float)(i / 2) / (float)((ver_num - 1) / 2));
                    vertices[i].TextureCoordinate.Y = v + vs;
                    vertices[i].Color = new Color(fAlphaIn, fAlphaIn, fAlphaIn, fAlphaIn);
                }
                else
                {
                    //外周
                    vertices[i].Position = Add * 1.0f;
                    vertices[i].TextureCoordinate.X = u + us * ((float)(i / 2) / (float)((ver_num - 1) / 2));
                    vertices[i].TextureCoordinate.Y = v;
                    vertices[i].Color = new Color(fAlphaOut, fAlphaOut, fAlphaOut, fAlphaOut);
                }
            }

            FrkLibEffectManager mng = FrkLibEffectManager.GetInstance();
            GraphicsDevice GrfDevice = mng.GetGrfDev();
            BasicEffect basicEffect = mng.GetEffect();

            // エフェクトの使用を開始します
            basicEffect.Begin();

            //基本的なポリラインの描画
            // 描画する頂点データの定義を設定
            GrfDevice.VertexDeclaration = mng.GetVertexDeclaration();


            // パスの数だけ繰り替えし描画 (BasicEffect は通常１回)
            for (int i = 0; i < basicEffect.CurrentTechnique.Passes.Count; i++)
            {
                EffectPass pass = basicEffect.CurrentTechnique.Passes[i];
                // パスの開始
                pass.Begin();


                if (Param.Tex != null)
                {
                    basicEffect.TextureEnabled = true;
                    basicEffect.Texture = Param.Tex;
                }
                else
                {
                    basicEffect.Texture = null;
                    basicEffect.TextureEnabled = false;
                }
                basicEffect.LightingEnabled = false;
                basicEffect.VertexColorEnabled = true;

                // ポリゴンを描画する

                GrfDevice.RenderState.CullMode = CullMode.None;
                GrfDevice.RenderState.DepthBufferEnable = true;
                GrfDevice.RenderState.DepthBufferWriteEnable = false;

                // ビュー座標変換行列
                
                // 射影変換行列
                //Matrix projection = mng.GetProj();

                basicEffect.View = mng.View;

                Matrix drawmat;
                //ビルボードの場合の処理
                if (Param.BillBoard)
                {
                    Matrix view = mng.View;
                    view.Translation = Vector3.Zero;
                    Vector3 wp = matLast.Translation;
                    Matrix inv = Matrix.Invert(view);
                    drawmat = matRot * inv * matScaleLast * Matrix.CreateTranslation(wp);
                }
                else
                {
                    drawmat = matLast;
                }

                basicEffect.World = drawmat;
                basicEffect.Projection = mng.Proj;

                basicEffect.Alpha = 1.0f;
                basicEffect.CommitChanges();


                GrfDevice.DrawUserPrimitives<VertexPositionColorTexture>(
                    PrimitiveType.TriangleStrip,
                    vertices,
                    0,
                    ver_num - 2
                );


                // パスの終了
                pass.End();
            }

            // エフェクトの使用を終了する
            basicEffect.End();
        }
    }
}
