﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;

namespace FrkEffectLib
{
    static class PathEx
    {
        /// <summary>
        /// ../を考慮したパス結合を行う
        /// </summary>
        /// <param name="path1">パス1</param>
        /// <param name="path2">パス2</param>
        /// <returns>結合したパス</returns>
        public static string CombineEx(string path1, string path2)
        {
            //パス文字の調整
            path2 = path2.Replace('/', Path.DirectorySeparatorChar).Trim();
            while (path2.Substring(0, 3) == ".." + Path.DirectorySeparatorChar)
            {
                path1 = Path.GetDirectoryName(path1);
                path2 = path2.Substring(3);
            }
            return Path.Combine(path1, path2);
        }
    }
}
