﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework.Audio;
using System.IO;

namespace FrkEffectLib
{
    public class FrkLibSoundManager : FrkLibSoundManagerInterface
    {
        public float fVol;
        //最大同時再生音声
        public const int SOUND_NUM = 32;
        //同一音最大再生数
        public const int PLAY_NUM = 3;
        class SoundData
        {
            public SoundEffect se;
            public SoundEffectInstance[] si = new SoundEffectInstance[PLAY_NUM];
            public bool bPlay;
            public int[] nCnt = new int[PLAY_NUM];
            public bool[] bNextPlay = new bool[PLAY_NUM];
            public void SetSi()
            {
                for (int i = 0; i < PLAY_NUM; i++)
                {
                    si[i] = se.CreateInstance();
                    nCnt[i] = 0;
                    bNextPlay[i] = false;
                }
            }
        };
        //メンバ
        Dictionary<String, SoundData> SoundList;

        //コンストラクタ
        public FrkLibSoundManager()
        {
            fVol = 1.0f;
            SoundList = new Dictionary<String, SoundData>(SOUND_NUM);
        }
        //再生
        public bool PlaySound(String key)
        {
            SoundData p;
            if (key == null)
                return false;
            //キー名が登録されているかチェック
            if (!SoundList.TryGetValue(key, out p))
            {
                //登録されていないので新規登録
                if (!SetSound(key))
                {
                    //読み込みエラー
                    return false;
                }
            }
            //同一フレームに同じ音は鳴らさない
            SoundData data = SoundList[key];
            if (!data.bPlay)
            {
                int nOldIndex = 0;
                int w = 0;
                int i;
                for (i = 0; i < PLAY_NUM; i++)
                {
                    if (w > data.nCnt[i])
                    {
                        nOldIndex = i;
                        w = data.nCnt[i];
                    }
                    if (data.si[i].State == SoundState.Stopped)
                    {
                        data.si[i].Play();
                        data.nCnt[i] = 0;
                        break;
                    }
                }
                if (i == PLAY_NUM)
                {
                    //全部再生中の場合、一番古い奴を消して再生フラグを立てる
                    data.si[nOldIndex].Stop();
                    data.nCnt[nOldIndex] = 0;
                }
                SoundList[key].bPlay = true;
                //SoundList[key].si.Play();
            }
            return true;
        }
        //サウンドの登録
        public bool SetSound(String name)
        {
            SoundData p;
            //もし登録済みなら失敗を返す
            if (SoundList.TryGetValue(name, out p))
            {
                //登録済みなのでreturn
                return false;
            }
            if (p == null)
            {
                p = new SoundData();
            }
            //コンテントマネージャがセットされていた場合は通常の呼び出しを行う
            if (FrkLibEffectManager.GetInstance().Content != null)
            {
                p.se = FrkLibEffectManager.GetInstance().Content.Load<SoundEffect>(name);
            }
            else
            {
                //セットされていない場合、ファイルから読み込みを行う
                //...どうやって？
                p.se = null;
            }

            if (p.se != null)
            {
                //連装配列にセット
                p.SetSi();
                p.bPlay = false;

                SoundList.Add(name, p);
                return true;
            }
            else
            {
                return false;
            }
        }
        public void UpDate()
        {
            foreach (KeyValuePair<String, SoundData> data in SoundList)
            {
                data.Value.bPlay = false;
                for (int i = 0; i < PLAY_NUM; i++)
                {
                    data.Value.nCnt[i]++;
                    if (data.Value.bNextPlay[i])
                    {
                        data.Value.bNextPlay[i] = false;
                        data.Value.si[i].Play();
                    }
                }
            }
        }
    }
}
