﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using FrkEffectLib;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;
using System.IO;
using Microsoft.Xna.Framework.Audio;

namespace FrkEffectLib
{

    //エフェクト用汎用パラメーター
    public class EffectParam
    {
        static Dictionary<string, Texture2D> TextureCache = new Dictionary<string, Texture2D>();
        
        public static void ClearCache()
        {
            TextureCache.Clear();
        }

        public EffectParam(EffectParam mom)
        {
            pMom = mom;
            System.Diagnostics.Debug.WriteLine("Create");
        }
        //オブジェタイプ
        public OBJTYPE Type;
        public void SetObjType(string type)
        {
            switch(type)
            {
                case "NODE":
                    Type = OBJTYPE.NODE;
                    break;
                case "QUAD":
                    Type = OBJTYPE.QUAD;
                    break;
                case "LINE":
                    Type = OBJTYPE.LINE;
                    break;
                case "DISC":
                    Type = OBJTYPE.DISC;
                    break;
                case "WAVE":
                    Type = OBJTYPE.WAVE;
                    break;
                case "SPHERE":
                    Type = OBJTYPE.SPHERE;
                    break;
            }
        }
        //親のパラメータ
        public EffectParam pMom;

        //生存時間
        public uint LiveTime;
        public void SetLiveTime(uint n) { LiveTime = n; }
        public uint GetLiveTime() { return LiveTime; }
        //生成後も親に追随するかフラグ
        public bool ChildFlg;
        public void SetChildFlg(bool b) { ChildFlg = b; }
        

        //回転角度
        public Quaternion Qua;        
        //座標
        public Vector3 Pos;
        public void SetPos(float x, float y, float z) { Pos.X = x; Pos.Y = y; Pos.Z = z; }
        public float[] GetPos() { return new float[] {Pos.X,Pos.Y,Pos.Z}; }
        //速度
        public Vector3 Vec, AddVec, MulVec;
        public float[] GetVec() { return new float[] { Vec.X, Vec.Y, Vec.Z }; }
        public void SetVec(float x, float y, float z) { Vec.X = x; Vec.Y = y; Vec.Z = z; }
        public void SetAddVec(float x, float y, float z) { AddVec.X = x; AddVec.Y = y; AddVec.Z = z; }
        public void SetMulVec(float x, float y, float z) { MulVec.X = x; MulVec.Y = y; MulVec.Z = z; }
        //テクスチャ
        public Texture2D Tex;
        public void SetTexture(String path)
        {
            if (path.CompareTo("null") == 0)
                Tex = null;
            else
            {
                if (FrkLibEffectManager.GetInstance().Content != null)
                {//コンテンツマネージャがセットされているので、それを使用
                    //拡張子を除去
                    string result;
                    if (pMom==null || !pMom.Data.TexPathCache.TryGetValue(path, out result))
                    {//キャッシュを仕様
                        result = Path.Combine(Path.GetDirectoryName(path), Path.GetFileNameWithoutExtension(path));
                        if (pMom != null)
                        {
                            result = PathEx.CombineEx(Path.GetDirectoryName(pMom.DataPath), result);
                            result = result.Replace('/', Path.DirectorySeparatorChar);
                        }
                        if (pMom != null)
                            pMom.Data.TexPathCache.Add(path, result);
                    }
                    Tex = FrkLibEffectManager.GetInstance().Content.Load<Texture2D>(result);
                }
                else
                {
#if WINDOWS
                    //スクリプトの相対パスを使って読みに行く
                    if (pMom != null)
                    {
                        path = PathEx.CombineEx(Path.GetDirectoryName(pMom.DataPath), path);
                        path = path.Replace('/', Path.DirectorySeparatorChar);
                    }
                    if (!TextureCache.TryGetValue(path, out Tex))
                    {//キャッシュに無ければ
                        //FromFileを使ってテクスチャ読み込み
                        
                        Tex = Texture2D.FromFile(FrkLibEffectManager.GetInstance().GetGrfDev(), path);
                        TextureCache.Add(path, Tex);
                    }
#else
                    throw new NullReferenceException("XBoxではコンテンツマネージャーをセットしないでテクスチャの読み込みは出来ません");
#endif
                }
            }
        }
        //UV値
        public Vector2 UVPos;
        public void SetUVPos(float x, float y) { UVPos.X = x; UVPos.Y = y; }
        public float[] GetUVPos() { return new float[] { UVPos.X, UVPos.Y}; }
        //UVサイズ
        public Vector2 UVSize;
        public void SetUVSize(float x, float y) { UVSize.X = x; UVSize.Y = y; }
        public float[] GetUVSize() { return new float[] { UVSize.X, UVSize.Y }; }
        //UV速度
        public Vector2 UVVec, AddUVVec, MulUVVec;
        public float[] GetUVVec() { return new float[] { UVVec.X, UVVec.Y}; }
        public void SetUVVec(float x, float y) { UVVec.X = x; UVVec.Y = y;}
        public void SetAddUVVec(float x, float y) { AddUVVec.X = x; AddUVVec.Y = y; }
        public void SetMulUVVec(float x, float y) { MulUVVec.X = x; MulUVVec.Y = y;  }
        //回転速度(ヨーピッチロール）
        public Vector3 Rot, RotVec, AddRot, MulRot;
        public float[] GetRot() { return new float[] { Rot.X, Rot.Y, Rot.Z }; }
        public void SetRot(float x, float y, float z) { Rot.X = x; Rot.Y = y; Rot.Z = z; }
        public void SetRotVec(float x, float y, float z) { RotVec.X = x; RotVec.Y = y; RotVec.Z = z; }
        public void SetAddRot(float x, float y, float z) { AddRot.X = x; AddRot.Y = y; AddRot.Z = z; }
        public void SetMulRot(float x, float y, float z) { MulRot.X = x; MulRot.Y = y; MulRot.Z = z; }
        //拡大
        public Vector3 Scale, AddScale, MulScale;
        public float[] GetScale() { return new float[] { Scale.X, Scale.Y, Scale.Z }; }
        public void SetScale(float x, float y, float z) { Scale.X = x; Scale.Y = y; Scale.Z = z; }
        public void SetAddScale(float x, float y, float z) { AddScale.X = x; AddScale.Y = y; AddScale.Z = z; }
        public void SetMulScale(float x, float y, float z) { MulScale.X = x; MulScale.Y = y; MulScale.Z = z; }
        //透明度1
        public float Alpha1, AddAlpha1, MulAlpha1;
        public float GetAlpha1() { return Alpha1; }
        public void SetAlpha1(float f) { Alpha1 = f; }
        public void SetAddAlpha1(float f) { AddAlpha1 = f; }
        public void SetMulAlpha1(float f) { MulAlpha1 = f; }
        //透明度2
        public float Alpha2, AddAlpha2, MulAlpha2;
        public float GetAlpha2() { return Alpha2; }
        public void SetAlpha2(float f) { Alpha2 = f; }
        public void SetAddAlpha2(float f) { AddAlpha2 = f; }
        public void SetMulAlpha2(float f) { MulAlpha2 = f; }
        //分割数
        public uint SplitNum;
        public void SetSplitNum(uint num) { SplitNum = num; }
        //外円に対する内円の割合
        public float InRatio, AddInRatio, MulInRatio;
        public float GetInRatio() { return InRatio; }
        public void SetInRatio(float f) { InRatio = f; }
        public void SetAddInRatio(float f) { AddInRatio = f; }
        public void SetMulInRatio(float f) { MulInRatio = f; }
        //描画タイプ
        public DRAWLAYER DrawLayer;
        public void SetDrawLayer(string tgt)
        {
            switch (tgt)
            {
                case "ALPHA":
                    DrawLayer = DRAWLAYER.ALPHA;
                    break;
                case "ADD":
                    DrawLayer = DRAWLAYER.ADD;
                    break;
                case "DISP_ALPHA":
                    DrawLayer = DRAWLAYER.DISP_ALPHA;
                    break;
                case "DISP_ADD":
                    DrawLayer = DRAWLAYER.DISP_ADD;
                    break;
                case "SYSTEM":
                    DrawLayer = DRAWLAYER.SYSTEM;
                    break;
            }
        }
        //ビルボードフラグ
        public bool BillBoard;
        public void SetBillBoard(bool b) { BillBoard = b; }
        //ラインのブレ
        public float Thunder;
        public void SetThunder(float f) { Thunder = f; }
        //参照スクリプトデータ
        public FrkLibEffectData Data;
        //参照スクリプトパス
        public String DataPath;
        public void SetDataPath(string path)
        {
            if (path.CompareTo("null") == 0)
            {
                Data = null;
                DataPath = null;
            }
            else
            {
                string result;
                if (pMom==null || !pMom.Data.ScriptPathCache.TryGetValue(path, out result))
                {
                    result = path;
                    if (pMom != null)
                    {
                        result = PathEx.CombineEx(Path.GetDirectoryName(pMom.DataPath), path);
                    }
                    if (pMom != null)
                        pMom.Data.ScriptPathCache.Add(path, result);
                }
                Data = new FrkLibEffectData(result);
                DataPath = result;
            }
        }
        //色
        public Color Col;
        public void SetColor(byte r, byte g, byte b)
        {
            Col = new Color(r, g, b);
        }
        //


        //生成用パラメータ→動作用パラメータにコピー
        public void Copy(EffectParam data)
        {
            Copy(this, data);
        }
        public void Copy(EffectParam tgt, EffectParam data)
        {
            //追随フラグ
            tgt.ChildFlg = data.ChildFlg;
            //参照スクリプトデータ
            tgt.Data = data.Data;
            //参照スクリプトパス
            tgt.DataPath = data.DataPath;
            //オブジェタイプ
            tgt.Type = data.Type;
            //生存時間
            tgt.LiveTime = data.LiveTime;
            //座標
            tgt.Pos = data.Pos;
            //回転角度
            tgt.Qua = data.Qua;
            //テクスチャ
            tgt.Tex = data.Tex;
            //UV
            tgt.UVPos = data.UVPos;
            tgt.UVSize = data.UVSize;
            tgt.UVVec = data.UVVec;
            tgt.AddUVVec = data.AddUVVec;
            tgt.MulUVVec = data.MulUVVec;

            //速度
            tgt.Vec = data.Vec;
            tgt.AddVec = data.AddVec;
            tgt.MulVec = data.MulVec;

            //回転(ヨーピッチロール）
            tgt.Rot = data.Rot;
            tgt.RotVec = data.RotVec;
            tgt.AddRot = data.AddRot;
            tgt.MulRot = data.MulRot;
            //拡大
            tgt.Scale = data.Scale;
            tgt.AddScale = data.AddScale;
            tgt.MulScale = data.MulScale;

            //透明度
            tgt.Alpha1 = data.Alpha1;
            tgt.AddAlpha1 = data.AddAlpha1;
            tgt.MulAlpha1 = data.MulAlpha1;

            tgt.Alpha2 = data.Alpha2;
            tgt.AddAlpha2 = data.AddAlpha2;
            tgt.MulAlpha2 = data.MulAlpha2;
            //分割数
            tgt.SplitNum = data.SplitNum;
            //外円に対する内円の割合
            tgt.InRatio = data.InRatio;
            tgt.AddInRatio = data.AddInRatio;
            tgt.MulInRatio = data.MulInRatio;
            //描画タイプ
            tgt.DrawLayer = data.DrawLayer;
            //ビルボードフラグ
            tgt.BillBoard = data.BillBoard;
            //ラインのブレ
            tgt.Thunder = data.Thunder;
            //色
            tgt.Col = data.Col;
        }

        //初期化
        public void Init()
        {
            //追随フラグ
            ChildFlg = false;
            //スクリプト
            Data = null;
            //オブジェタイプ
            Type = OBJTYPE.NODE;
            //生存時間
            LiveTime = 0;
            //座標
            Pos = Vector3.Zero;
            //速度
            Vec = Vector3.Zero;
            AddVec = Vector3.Zero;
            MulVec = Vector3.One;
            //テクスチャ
            Tex = null;
            //UV
            UVPos = Vector2.Zero;
            UVSize = Vector2.One;
            UVVec = Vector2.Zero;
            AddUVVec = Vector2.Zero;
            MulUVVec = Vector2.One;

            //回転角度
            Qua = Quaternion.Identity;

            //回転速度(ヨーピッチロール）
            Rot = Vector3.Zero;
            RotVec = Vector3.Zero;
            AddRot = Vector3.Zero;
            MulRot = Vector3.One;
            //拡大
            Scale = Vector3.One;
            AddScale = Vector3.Zero;
            MulScale = Vector3.One;

            //透明度
            Alpha1 = 1.0f;
            AddAlpha1 = 0.0f;
            MulAlpha1 = 1.0f;
            Alpha2 = 1.0f;
            AddAlpha2 = 0.0f;
            MulAlpha2 = 1.0f;
            //分割数
            SplitNum = 8;
            //外円に対する内円の割合
            InRatio = 0.5f;
            AddInRatio = 0.0f;
            MulInRatio = 1.0f;
            //描画タイプ
            DrawLayer = DRAWLAYER.ALPHA;

            //ビルボードフラグ
            BillBoard = false;
            //ラインのブレ
            Thunder = 0.0f;
            //色
            Col = Color.White;
        }
    }
}
