﻿using System;
using System.Collections.Generic;
using System.Text;
using nft.ui.mainframe;
using nft.framework.drawing;
using nft.framework.util;
using nft.framework;
using System.Drawing;
using System.IO;

namespace nft.debug {
    public class TestViewDrawer : ViewDrawerBase{
        private static readonly String ImagePath = 
            Path.Combine(System.Environment.GetFolderPath(Environment.SpecialFolder.MyPictures),
            @"hokkaido_gs.bmp");

        private ImageRef imgRef;
        private ISurface surface;

        public TestViewDrawer() {
            imgRef = LocalFileImageRef.FromFile(ImagePath);
            DoubleBuffered = false;
            surface = null;
        }

        protected override void DrawCore(ISurface surfDest, Graphics g, IView owner, Rectangle rctDest, Region requestSrc) {
            if (surface != null) {
                IGraphicManager gm = GlobalModules.GraphicManager;
                DrawParams dp = new DrawParams(surfDest, rctDest.Location);
                dp.SoruceClip = Rectangle.Round(requestSrc.GetBounds(g));
                surfDest.BitBlt( surface, dp);
            }
        }

        public override Size ContentSize {
            get { return imgRef.Image.Size; }
        }

        public override Size ScrollUnit {
            get {
                Size sz = ContentSize;
                return new Size(sz.Width>>3,sz.Height>>3); 
            }
        }

        public override void Attach(IView view) {
            base.Attach(view);
            imgRef.AddRef();
            if (surface == null) {
                IGraphicManager gm = GlobalModules.GraphicManager;
                surface = gm.CreateSurfaceFromBitmap(imgRef.Image);
            }
        }

        public override void Detach(IView view) {
            base.Detach(view);
            imgRef.ReleaseRef();
            if (AttachedViewCount == 0) {
                surface.Dispose();
                surface = null;
            }
        }
    }
}
