﻿
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using nft.framework;
using nft.framework.plugin;
using System.Diagnostics;
using nft.ui.command;
using System.IO;

namespace nft.debug {
    public partial class CacheDirManageForm : Form {
        public CacheDirManageForm() {
            InitializeComponent();
            string path = PluginManager.ChachedDataDirectory;
            tbCachePath.Text = path;
            labelDiskSize.Text = ToByteSizeText(Directories.GetDirectorySize(path));
        }

        private string[] size_units = { "B", "kB", "MB", "TB" };
        private string ToByteSizeText(long s) {
            int i = 0;
            while (s > 1000) {
                i++;
                s /= 1000;
            }
            return s.ToString() + size_units[i];
        }

        private void btnExplorer_Click(object sender, EventArgs e) {
            Process.Start("explorer.exe", "/e," + PluginManager.ChachedDataDirectory);
        }

        private void btnClear_Click(object sender, EventArgs e) {
            Form win = Main.mainFrame as Form;
            win.Disposed += new EventHandler(DeleteCacheDir);
            win.Close();
        }

        void DeleteCacheDir(object sender, EventArgs e) {
            Directory.Delete(PluginManager.ChachedDataDirectory, true);
        }

        private void btnCancel_Click(object sender, EventArgs e) {
            this.Close();
        }
    }
}
