﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Collections;
using nft.framework.drawing;
using System.Drawing;
using nft.core.geometry;
using System.Diagnostics;

namespace nft.impl.view {
    public class SpriteQueue {
        readonly private ArrayList list;
        private bool ascending = true;

        public SpriteQueue() {
            list = new ArrayList();
        }

        public SpriteQueue(int capacity) {
            list = new ArrayList(capacity);
        }

        public void Clear(bool disposeSprites) {
            if (disposeSprites) {
                int n = list.Count;
                for (int i = 0; i < n; i++) {
                    object o = list[i];
                    if (o is ISprite) {
                        ((ISprite)o).Dispose();
                    } else {
                        SpriteQueue substack = (SpriteQueue)o;
                        substack.Clear(disposeSprites);
                    }
                }
            } else {
                foreach (object o in list) {
                    SpriteQueue substack = o as SpriteQueue;
                    if(substack!=null)
                        substack.Clear(disposeSprites);
                }
                list.Clear();
            }
        }

        public void AddLast(ISprite s) {
            if (s != null) {
                list.Add(s);
            }
        }

        public void AddFirst(ISprite s) {
            if (s != null) {
                list.Insert(0,s);
            }
        }

        public void AddLast(SpriteQueue sub) {
            Debug.Assert(sub != null && sub !=this);
            list.Add(sub);
        }

        public void AddFirst(SpriteQueue sub) {
            Debug.Assert(sub != null && sub != this);
            list.Insert(0, sub);
        }

        public bool IsEmpty() {
            return list.Count==0;
        }

        public bool AscendingOrder {
            get { return ascending; }
            set { ascending = value; }
        }

        /// <summary>
        /// Enumerate sprites from last index to 0.
        /// </summary>
        /// <returns></returns>
        public IEnumerable<ISprite> GetDescendEnumerator() {
            if (!IsEmpty()) {
                int n = list.Count - 1;
                for (int i = n; i >= 0; i--) {
                    object o = list[i];
                    if (o is ISprite) {
                        yield return (ISprite)o;
                    } else {
                        SpriteQueue substack = (SpriteQueue)o;
                        foreach (ISprite s in substack.GetDescendEnumerator())
                            yield return (ISprite)s;
                    }
                }
            }
            yield break;
        }

        /// <summary>
        /// Enumerate sprites from 0 to last index.
        /// </summary>
        /// <returns></returns>
        public IEnumerable<ISprite> GetAscendEnumerator() {
            if (!IsEmpty()) {
                int n = list.Count;
                for (int i = 0; i < n; i++) {
                    object o = list[i];
                    if (o is ISprite) {
                        yield return (ISprite)o;
                    } else {
                        SpriteQueue substack = (SpriteQueue)o;
                        foreach (ISprite s in substack.GetAscendEnumerator())
                            yield return (ISprite)s;
                    }
                }
            }
            yield break;
        }

        internal void Clear() {
            throw new NotImplementedException();
        }
    }

}
