﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;
using DefaultEffect = StockEffects.DefaultEffect;
using nft.framework.drawing;
using System.Diagnostics;

namespace nft.xna
{
    public abstract class XnaFilter : IEffectFilter
    {
        internal abstract void BeforeDraw(DefaultEffect effect, IDrawable draw);
        internal virtual void AfterDraw(DefaultEffect effect, IDrawable draw) { }
    }

    public class FilterSelected : XnaFilter
    {
        static private RasterizerState rasterizerState;
        static FilterSelected() {
            rasterizerState = new RasterizerState();
            rasterizerState.FillMode = FillMode.WireFrame;
            //rasterizerState.FillMode = FillMode.Solid;
        }
        private RasterizerState backupState;

        internal override void BeforeDraw(DefaultEffect effect, IDrawable draw) {
            GraphicsDevice gd = effect.GraphicsDevice;
            backupState = gd.RasterizerState;
            gd.RasterizerState = rasterizerState;
            effect.DiffuseColor = new Vector3(1.0f,0,0);
        }

        internal override void AfterDraw(DefaultEffect effect, IDrawable draw) {
            GraphicsDevice gd = effect.GraphicsDevice;
            gd.RasterizerState = backupState;
        }
    }
}
