//-----------------------------------------------------------------------------
// AlphaTestEffect.fx
//
// Microsoft XNA Community Game Platform
// Copyright (C) Microsoft Corporation. All rights reserved.
//-----------------------------------------------------------------------------

#include "Macros.fxh"

DECLARE_TEXTURE(Texture, 0);


BEGIN_CONSTANTS

    float4 DiffuseColor     _vs(c0) _cb(c0);
    float4 AlphaTest        _ps(c0) _cb(c1);
    float3 FogColor         _ps(c1) _cb(c2);
	float3 ObjKey           _ps(c1) _cb(c2);
    float4 FogVector        _vs(c5) _cb(c3);
	//Texture offset
	float2 TextureOffset;
	float2 TextureScale;
MATRIX_CONSTANTS

    float4x4 WorldViewProj  _vs(c1) _cb(c0);
    float4x4 World          _vs(c6) _cb(c1);

END_CONSTANTS


#include "Structures.fxh"
#include "Common.fxh"


struct PS_MRT_Output {     
	float4 RgbColor  : SV_Target0;//RendarTarget0Ԗڂɏo 
    float4 DepthColor: SV_Target1;//RendarTarget1Ԗڂɏo 
};

// Vertex shader: textured & Fog. ## not used 
VSOutputTx VSAlphaTest(VSInputTx vin)
{
    VSOutputTx vout;
    
    SetCommonVSOutputParams;
    AdjustTextureRegion;
	vout.Specular.a = CalcDepthParam;

    return vout;
}

// Vertex shader: vertex color & Fog. ## not used 
VSOutput VSBasicVc(VSInputVc vin)
{
    VSOutput vout;
    
    SetCommonVSOutputParams;
	vout.Specular.a = CalcDepthParam;
    vout.Diffuse *= vin.Color;

	return vout;
}

// Vertex shader: Normal, Textured
VSOutputTx VSNormal(VSInputTx vin)
{
    VSOutputTx vout;
    
    SetCommonVSOutputParamsNoFog;
    AdjustTextureRegion;
	vout.Specular = 0;

    return vout;
}

// Vertex shader: Normal, Vertex color.
VSOutput VSNormalVc(VSInputVc vin)
{
    VSOutput vout;
    
    SetCommonVSOutputParamsNoFog;
    vout.Diffuse *= vin.Color;

    return vout;
}

// Vertex shader: PreCombined, Textured
VSOutputTx VSPreCombined(VSInputTx vin)
{
    VSOutputTx vout;
    
    SetCommonVSOutputParamsNoFog;
    AdjustTextureRegion;
	vout.Specular.a = CalcDepthParam;

    return vout;
}

// Vertex shader: PreCombined, Vertex color.
VSOutput VSPreCombinedVc(VSInputVc vin)
{
    VSOutput vout;
    
    SetCommonVSOutputParamsNoFog;
    vout.Diffuse *= vin.Color;
	vout.Specular.a = CalcDepthParam;

    return vout;
}


// Vertex shader: GameView, Textured
VSOutputTx VSGameView(VSInputTx vin)
{
    VSOutputTx vout;
    
    SetCommonVSOutputParamsNoFog;
    AdjustTextureRegion;
	vout.Diffuse.a = CalcDepthParam;

    return vout;
}

// Vertex shader: GameView, Vertex color.
VSOutput VSGameViewVc(VSInputVc vin)
{
    VSOutput vout;
    
    SetCommonVSOutputParamsNoFog;
    vout.Diffuse *= vin.Color;
	vout.Specular.a = CalcDepthParam;

    return vout;
}


// Pixel shader: Textured. Fog enabled. ## not used
PS_MRT_Output PSAlphaTest(PSInputTx pin)
{
	PS_MRT_Output result;

    SetCommonPSOutputTx;

    ApplyFog(result.RgbColor, pin.Specular.w);

    return result;
}


// Pixel shader: Vertex color. Fog enabled ## not used
PS_MRT_Output PSBasic(PSInput pin)
{
	PS_MRT_Output result;
		
	SetCommonPSOutputVc;
    
    ApplyFog(result.RgbColor, pin.Specular.w);
    
    return result;
}

// Pixel shader: SRT, Textured.
float4 PSBasicTx(PSInputTx pin) : SV_Target0
{
	PS_MRT_Output result;

    SetCommonPSOutputTx;

    return color;
}

// Pixel shader: SRT, Vertex color.
float4 PSBasicVc(PSInput pin) : SV_Target0
{    
	PS_MRT_Output result;
		
	SetCommonPSOutputVc;

    return color;
}

// Pixel shader: MRT, Textured.
PS_MRT_Output PSMultiPathTx(PSInputTx pin)
{
	PS_MRT_Output result;

    SetPS_MRT_OutputTx;

    return result;
}

// Pixel shader: MRT, Vertex color.
PS_MRT_Output PSMultiPathVc(PSInput pin)
{    
	PS_MRT_Output result;
		
	SetPS_MRT_OutputVc;
	// Under SEA effect test.
	if( pin.PositionW.y < 30 ){
	  // rgba
	  result.RgbColor *= float4(0.5,0.8,1.0,1.0);
    }
	if(round(pin.PositionW.x) == 10 || round(pin.PositionW.z) == 10){
	  result.RgbColor *= float4(0.5,1.0,0.5,1.0);
	}
    return result;
}

VertexShader VSArray[6] =
{
    compile vs_2_0 VSNormal(),
    compile vs_2_0 VSNormalVc(),
    compile vs_2_0 VSPreCombined(),
    compile vs_2_0 VSPreCombinedVc(),
    compile vs_2_0 VSGameView(),
    compile vs_2_0 VSGameViewVc(),
};


int VSIndices[6] =
{
    0,      // Normal, Textured
    1,      // Normal, Vertex color
    2,      // PreCombined, Textured
    3,      // PreCombined, Vertex color
	4,      // GameView, Textured
	5,      // GameView, Vertex color
};


PixelShader PSArray[4] =
{
    compile ps_2_0 PSBasicTx(),
    compile ps_2_0 PSBasicVc(),
    compile ps_2_0 PSMultiPathTx(),
    compile ps_2_0 PSMultiPathVc(),
};

int PSIndices[6] =
{
    0,      // Normal, Textured
    1,      // Normal, Vertex color
    2,      // PreCombined, Textured
    3,      // PreCombined, Vertex color
	2,      // GameView, Textured
	3,      // GameView, Vertex color
};


int ShaderIndex = 0;


Technique CustomEffect
{
    Pass
    {
        VertexShader = (VSArray[VSIndices[ShaderIndex]]);
        PixelShader  = (PSArray[PSIndices[ShaderIndex]]);
    }
}
