// 2008.09.06 YZ Fixed dialog size
using System;
using System.Drawing;
using System.Windows.Forms;
using freetrain.controllers;
using freetrain.framework;
using freetrain.views;
using freetrain.views.map;
using freetrain.world.rail;

namespace freetrain.world.rail.tattc
{
	/// <summary>
	/// ModalController that configures a TATTrainController.
	/// </summary>
	internal class TATModalController : AbstractControllerImpl, LocationDisambiguator, MapOverlay
	{
		public TATModalController( TATTrainController controller ) {
			this.controller = controller;
			InitializeComponent();

			this.Text = string.Format("_Cݒu{0}v",controller.name);

			label1.Text = string.Format("{0}\n\n{1}",controller.name, label1.Text );
			Show();
			Activate();

			// redraw the view so that arrows will be displayed
			World.world.onAllVoxelUpdated();
		}

		private readonly TATTrainController controller;

		protected override void Dispose( bool disposing ) {
			if( disposing && components != null)
				components.Dispose();
			base.Dispose( disposing );
		}


		public override void onClick( MapViewWindow view, Location loc, Point ab ) {
			JunctionRailRoad jrr = JunctionRailRoad.get(loc);
			if( jrr!=null ) {
				Form dialog = new JunctionConfigDialog( controller.getOrCreateJunction(loc) );
				dialog.ShowDialog(MainWindow.mainWindow);
				return;
			}

			Voxel v = World.world[loc];
			if(v==null)		return;

			TrainHarbor harbor = (TrainHarbor)v.queryInterface(typeof(TrainHarbor));

			if(harbor!=null) {
				StationHandler handler = controller.getStationHandler(harbor);
				StationConfigDialog dialog = new StationConfigDialog( handler );
				dialog.ShowDialog(MainWindow.mainWindow);
				controller.setStationHandler( harbor, dialog.currentHandler );
				return;
			}
		}


		//
		// Disambiguator implementation
		//
		public override LocationDisambiguator disambiguator { get { return this; } }

		public bool isSelectable( Location loc ) {
			Voxel v = World.world[loc];
			if(v==null)		return false;

			// any junctions, platforms, stations are selectable
			return JunctionRailRoad.get(loc)!=null || v.queryInterface(typeof(TrainHarbor))!=null;
		}


		//
		// MapOverlay implementation
		//
		public void drawVoxel( QuarterViewDrawer view, DrawContextEx context, Location loc, Point pt ) {
			JunctionRailRoad jrr = JunctionRailRoad.get(loc);
			if( jrr==null )	return;

			// draw an arrow that indicates the direction to go
			JunctionRoute go; bool isSimple=true;
			
			Junction j = controller.getJunction(loc);
			if(j==null)
				go = JunctionRoute.Straight;
			else {
				go = j.defaultRoute;
				if( j.advancedRules.Count!=0 )
					isSimple = false;
			}

			// draw an arrow.
			pt.Y -= 2;
			jrr.getDirection(go).drawArrow( context.surface, pt, !isSimple );
		}

		public void drawBefore( QuarterViewDrawer view, DrawContextEx context ) {}
		public void drawAfter( QuarterViewDrawer view, DrawContextEx context ) {}

		private void buttonOK_Click(object sender, System.EventArgs e) {
			Close();
		}

		#region Designer generated code
		private System.ComponentModel.Container components = null;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Button buttonOK;

		/// <summary>
		/// Designer T|[gɕKvȃ\bhłBR[h GfB^
		/// ̃\bh̃RecύXȂłB
		/// </summary>
		private void InitializeComponent() {
        this.label1 = new System.Windows.Forms.Label();
        this.buttonOK = new System.Windows.Forms.Button();
        this.SuspendLayout();
        // 
        // label1
        // 
        this.label1.Location = new System.Drawing.Point(10,10);
        this.label1.Name = "label1";
        this.label1.Size = new System.Drawing.Size(124,80);
        this.label1.TabIndex = 0;
        this.label1.Text = "|CgAz[AwNbNă_Cݒ肵Ă";
        // 
        // buttonOK
        // 
        this.buttonOK.Location = new System.Drawing.Point(48,100);
        this.buttonOK.Name = "buttonOK";
        this.buttonOK.Size = new System.Drawing.Size(86,30);
        this.buttonOK.TabIndex = 1;
        this.buttonOK.Text = "(&C)";
        this.buttonOK.Click += new System.EventHandler(this.buttonOK_Click);
        // 
        // TATModalController
        // 
        this.AutoScaleBaseSize = new System.Drawing.Size(6,15);
        this.ClientSize = new System.Drawing.Size(150,135);
        this.Controls.Add(this.buttonOK);
        this.Controls.Add(this.label1);
        this.Name = "TATModalController";
        this.Text = "_Cݒ";
        this.ResumeLayout(false);

		}
		#endregion
	
	}
}
