using System;
using System.Diagnostics;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using freetrain.framework;
using freetrain.framework.graphics;
using freetrain.util;
using freetrain.world;
using freetrain.world.rail;
using freetrain.views;
using freetrain.views.map;
using freetrain.controllers;
using freetrain.controllers.rail;
using freetrain.DirectXWrapper;


namespace freetrain.world.rail.speedlimit
{
	/// <summary>
	/// x_CAO
	/// </summary>
	public class SpeedLimitRailRoadController :  AbstractControllerImpl, MapOverlay
	{
		#region Singleton instance management
		/// <summary>
		/// Creates a new controller window, or active the existing one.
		/// </summary>
		public static void create() {
			if(theInstance==null)
				theInstance = new SpeedLimitRailRoadController();
			theInstance.Show();
			theInstance.Activate();
		}

		private System.Windows.Forms.ComboBox comboBoxSpeed;
		private System.Windows.Forms.Label labelSpeed;

		private static SpeedLimitRailRoadController theInstance;

		protected override void OnClosing(System.ComponentModel.CancelEventArgs e) {
			base.OnClosing(e);
			theInstance = null;
		}
		#endregion
		

		/// <summary>
		/// RXgN^
		/// </summary>
		private SpeedLimitRailRoadController() 
		{
			InitializeComponent();
			updatePreview();

			setSpeedList();
		}


		/// <summary>
		/// 
		/// </summary>
		public override void updatePreview()
		{
			using( PreviewDrawer drawer = new PreviewDrawer( picture.Size, new Size(1,10), 0 ) ) 
			{
				for( int i=0; i<10; i++ )
					drawer.draw( RailPattern.get( Direction.NORTH, Direction.SOUTH ), 0, i );
				if(picture.Image!=null) picture.Image.Dispose();
				picture.Image = drawer.createBitmap();
			}
		}


		/// <summary>
		/// 
		/// </summary>
		protected override void Dispose( bool disposing ) 
		{
			if( disposing && components != null)
					components.Dispose();
			base.Dispose( disposing );
		}


		/// <summary>
		/// _CAO{bNX̃bZ[WXVB@
		/// Updates the message in the dialog box.
		/// </summary>
		private void updateDialog() {
			message.Text = anchor!=UNPLACED?
				"I_Ił":"n_Ił";
		}


		/// <summary>
		/// [U[ɂčŏɑI΂ꂽn_@
		/// The first location selected by the user.
		/// </summary>
		private Location anchor = UNPLACED;


		/// <summary>
		/// ݂̃}EX|WVB@anchor!=UNPLACED ̂Ƃ̂ݎgpB
		/// Current mouse position. Used only when anchor!=UNPLACED
		/// </summary>
		private Location currentPos = UNPLACED;


		/// <summary>
		/// ʒuȂƂ\Ȓl
		/// </summary>
		private static Location UNPLACED = freetrain.world.Location.UNPLACED;


		/// <summary>
		/// {݃{^Ă邩ǂ
		/// </summary>
		private bool isPlacing { get { return buttonPlace.Checked; } }





		#region Windows Form Designer generated code
		/// <summary>
		/// {݃{^
		/// </summary>
		private System.Windows.Forms.RadioButton buttonPlace;
		/// <summary>
		/// P{^
		/// </summary>
		private System.Windows.Forms.RadioButton buttonRemove;
		private System.Windows.Forms.Label message;
		private System.Windows.Forms.PictureBox picture;
		private System.ComponentModel.Container components = null;

		private void InitializeComponent()
		{
            this.picture = new System.Windows.Forms.PictureBox();
            this.message = new System.Windows.Forms.Label();
            this.buttonPlace = new System.Windows.Forms.RadioButton();
            this.buttonRemove = new System.Windows.Forms.RadioButton();
            this.comboBoxSpeed = new System.Windows.Forms.ComboBox();
            this.labelSpeed = new System.Windows.Forms.Label();
            ((System.ComponentModel.ISupportInitialize)(this.picture)).BeginInit();
            this.SuspendLayout();
            // 
            // picture
            // 
            this.picture.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
            this.picture.Location = new System.Drawing.Point(8, 8);
            this.picture.Name = "picture";
            this.picture.Size = new System.Drawing.Size(96, 72);
            this.picture.TabIndex = 0;
            this.picture.TabStop = false;
            // 
            // message
            // 
            this.message.Location = new System.Drawing.Point(8, 88);
            this.message.Name = "message";
            this.message.Size = new System.Drawing.Size(96, 24);
            this.message.TabIndex = 1;
            this.message.Text = "}bv̂Q_NbNĐݒ";
            // 
            // buttonPlace
            // 
            this.buttonPlace.Appearance = System.Windows.Forms.Appearance.Button;
            this.buttonPlace.Checked = true;
            this.buttonPlace.Location = new System.Drawing.Point(8, 168);
            this.buttonPlace.Name = "buttonPlace";
            this.buttonPlace.Size = new System.Drawing.Size(48, 24);
            this.buttonPlace.TabIndex = 2;
            this.buttonPlace.TabStop = true;
            this.buttonPlace.Text = "ǉ";
            this.buttonPlace.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            this.buttonPlace.CheckedChanged += new System.EventHandler(this.modeChanged);
            // 
            // buttonRemove
            // 
            this.buttonRemove.Appearance = System.Windows.Forms.Appearance.Button;
            this.buttonRemove.Location = new System.Drawing.Point(56, 168);
            this.buttonRemove.Name = "buttonRemove";
            this.buttonRemove.Size = new System.Drawing.Size(48, 24);
            this.buttonRemove.TabIndex = 3;
            this.buttonRemove.Text = "폜";
            this.buttonRemove.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            this.buttonRemove.CheckedChanged += new System.EventHandler(this.modeChanged);
            // 
            // comboBoxSpeed
            // 
            this.comboBoxSpeed.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboBoxSpeed.Location = new System.Drawing.Point(32, 128);
            this.comboBoxSpeed.Name = "comboBoxSpeed";
            this.comboBoxSpeed.Size = new System.Drawing.Size(72, 20);
            this.comboBoxSpeed.TabIndex = 5;
            // 
            // labelSpeed
            // 
            this.labelSpeed.Location = new System.Drawing.Point(6, 119);
            this.labelSpeed.Name = "labelSpeed";
            this.labelSpeed.Size = new System.Drawing.Size(24, 37);
            this.labelSpeed.TabIndex = 9;
            this.labelSpeed.Text = "x";
            this.labelSpeed.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            // 
            // SpeedLimitRailRoadController
            // 
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 12);
            this.ClientSize = new System.Drawing.Size(112, 202);
            this.Controls.Add(this.labelSpeed);
            this.Controls.Add(this.comboBoxSpeed);
            this.Controls.Add(this.buttonPlace);
            this.Controls.Add(this.buttonRemove);
            this.Controls.Add(this.message);
            this.Controls.Add(this.picture);
            this.Name = "SpeedLimitRailRoadController";
            this.Text = "x";
            this.Load += new System.EventHandler(this.BlockSystemRailRoadController_Load);
            this.Closed += new System.EventHandler(this.BlockSystemRailRoadController_Closed);
            ((System.ComponentModel.ISupportInitialize)(this.picture)).EndInit();
            this.ResumeLayout(false);

		}
		#endregion


		/// <summary>
		/// 
		/// </summary>
		public override void onClick( MapViewWindow source, Location loc, Point ab ) 
		{
			if(anchor==UNPLACED) 
			{
				anchor = loc;
				sameLevelDisambiguator = new SameLevelDisambiguator(anchor.z);
			} 
			else 
			{
				if(anchor!=loc) 
				{
					if(isPlacing)
					{
						//xԐݒ
						build( anchor, loc );

						//H
						World.world.onAllVoxelUpdated();
					} 
					else
					{
						//xԍ폜
						remove( anchor, loc );

						//H
						World.world.onAllVoxelUpdated();
					}
				}
				anchor = UNPLACED;
			}

			updateDialog();
		}

		/// <summary>
		/// 
		/// </summary>
		public override void onRightClick( MapViewWindow source, Location loc, Point ab ) 
		{
			// cancel the anchor
			if(anchor!=UNPLACED && currentPos!=UNPLACED)
			{
				World.world.onVoxelUpdated(Cube.createInclusive(anchor,currentPos));
			}
			anchor = UNPLACED;
			updateDialog();
			
		}


		/// <summary>
		/// 
		/// </summary>
		public override void onMouseMove( MapViewWindow view, Location loc, Point ab ) 
		{
			//H
			if( anchor!=UNPLACED && isPlacing && currentPos!=loc ) {


				// update the screen
				if( currentPos!=UNPLACED ) {
					World.world.onVoxelUpdated(Cube.createInclusive(anchor,currentPos));
				}
				currentPos = loc;
				World.world.onVoxelUpdated(Cube.createInclusive(anchor,currentPos));
				
			}

			//P鎞
			if( anchor!=UNPLACED && !isPlacing ) {
						
			}
		}


		/// <summary>
		/// 
		/// </summary>
		public override void onDetached() 
		{
			anchor = UNPLACED;
		}

		/// <summary>
		/// 
		/// </summary>
		public override LocationDisambiguator disambiguator 
		{
			get {
				// the 2nd selection must go to the same height as the anchor.
				if(anchor==UNPLACED)	return RailRoadDisambiguator.theInstance;
				else					return sameLevelDisambiguator;
			}
		}
		
		/// <summary>
		/// 
		/// </summary>
		private LocationDisambiguator sameLevelDisambiguator;


		/// <summary>
		/// 
		/// </summary>
		protected override void OnVisibleChanged(System.EventArgs e) 
		{
			updateDialog();
		}
		



		// "place" or "remove" button was clicked. reset the anchor
		/// <summary>
		/// {݂܂͓P{^NbNꂽہAAJ[ZbgB
		/// </summary>
		private void modeChanged(object sender, EventArgs e) 
		{
			anchor = UNPLACED;
			updateDialog();
		}


		/// <summary>
		/// 
		/// </summary>
		public void drawBefore( QuarterViewDrawer view, DrawContextEx canvas ) 
		{
			if( anchor!=UNPLACED && isPlacing ) 
			{
				canvas.tag = comupteRoute( anchor, currentPos );
				if( canvas.tag!=null )
					Debug.WriteLine( ((IDictionary)canvas.tag).Count );
			}
		}


		/// <summary>
		/// 
		/// </summary>
		public void drawVoxel( QuarterViewDrawer view, DrawContextEx canvas, Location loc, Point pt ) 
		{
			Surface display = canvas.surface; 

			//Vݒ肷ǋԂłΕ`悷
			IDictionary dic = (IDictionary)canvas.tag;
			if( dic!=null ) {
				RailPattern rp = (RailPattern)dic[loc];
				if( rp!=null ) {
					for( int j=World.world.getGroundLevel(loc); j<loc.z; j++ )
						// ƂKvȂ
						BridgePierVoxel.defaultSprite.drawAlpha(
							canvas.surface,
							view.fromXYZToClient(loc.x,loc.y,j) );

					rp.drawAlpha( canvas.surface, pt ); 

					//ACR\
                    switch (this.comboBoxSpeed.Text)
                    {
                        case "ᑬ":
                            display.blt(pt, SpeedLimitManager.lowSpeedIcon);
                            break;
                        case "":
                            display.blt(pt, SpeedLimitManager.mediumSpeedIcon);
                            break;
                        case "":
                            display.blt(pt, SpeedLimitManager.fastSpeedIcon);
                            break;
                    }
				}
			}

			//xԂł΃ACR\
            SpeedLimit sl = SpeedLimit.getInstance();
            if (sl.LowSpeedLimit.Contains(loc))
            {
                display.blt(pt, SpeedLimitManager.lowSpeedIcon);
            }
            if (sl.MediumSpeedLimit.Contains(loc))
            {
                display.blt(pt, SpeedLimitManager.mediumSpeedIcon);
            }
            if (sl.FastSpeedLimit.Contains(loc))
            {
                display.blt(pt, SpeedLimitManager.fastSpeedIcon);
            }


		}


		/// <summary>
		/// 
		/// </summary>
		public void drawAfter( QuarterViewDrawer view, DrawContextEx canvas ) 
		{
		}



		/// <summary>
		/// Q̓肵n_Ԃ̑xԂݒ肷B@
		/// </summary>
		private void build( Location here, Location there ) {

			Hashtable route = (Hashtable)comupteRoute(here, there);			
			if(route==null) {return;}
			if(SpeedLimitManager.isNotOnlyTrafficVoxel(route))
            {
				MainWindow.showError("ݒłȂꏊłB");
				return;
			}
            SpeedLimit sp = SpeedLimit.getInstance();
            if (sp.Contains(route))
            {
                MainWindow.showError("ɐݒ肳Ă܂B");
                return;
            }


			//xԂVKǉ
            switch (this.comboBoxSpeed.Text)
            {
                case "ᑬ":
                    sp.addLowSpeedLimit(route);
                    break;
                case "":
                    sp.addMediumSpeedLimit(route);
                    break;
                case "":
                    sp.addFastSpeedLimit(route);
                    break;
            }
            
		}


		/// <summary>
		/// Q̓肵n_Ԃ̑x폜B@
		/// </summary>
		private void remove( Location here, Location there ) {
			
			Hashtable route = new Hashtable();
			route = (Hashtable)comupteRoute(here, there);
			
			if(route==null) {return;}

	
			
			//x폜
            SpeedLimit sp = SpeedLimit.getInstance();
            sp.removeLowSpeedLimit(route);
            sp.removeMediumSpeedLimit(route);
            sp.removeFastSpeedLimit(route);
		}


		/// <summary>
		/// R{{bNX̑x̃Xgݒ
		/// </summary>
		private void setSpeedList() {
			ArrayList list = new ArrayList();
			list.Add("ᑬ");
			list.Add("");
            list.Add("");
			this.comboBoxSpeed.DataSource = list;
		}


		/// <summary>
		/// Qn_Ԃ̑x̃P[VvZ
		/// 
		/// </summary>
		private static IDictionary comupteRoute( Location from, Location to ) {
			Hashtable route = new Hashtable();
			if(from==to) { return route; }

			Direction dir = null;

			for( Location loc = from; loc!=to; dir=loc.getDirectionTo(to).opposite, loc=loc.toward(to) ) {
				Direction dd = loc.getDirectionTo(to);
				route.Add( loc, RailPattern.get( dir!=null?dir:dd.opposite, dd ) );
			}

			route.Add( to, RailPattern.get( dir, dir.opposite ) );
			return route;
		}



		/// <summary>
		/// tH[鎞
		/// </summary>
		private void BlockSystemRailRoadController_Closed(object sender, System.EventArgs e) {
			World.world.onAllVoxelUpdated();
		}

        /// <summary>
        /// tH[J
        /// </summary>
        private void BlockSystemRailRoadController_Load(object sender, EventArgs e)
        {
            setSpeedList();
        }



	}

}
