import java.awt.*;
import java.awt.image.*;
import javax.swing.*;

import java.io.*;

public class Board implements ImageObserver{
    private int[][] data;
    private int[][] killRing;

    public int WIDTH, HEIGHT;
    public int KILLRING_WIDTH, KILLRING_HEIGHT;

    public static int CELL_WIDTH = 52;
    public static int CELL_HEIGHT = 52;
	

    public Board(int width, int height)
    {
	WIDTH = width;
	HEIGHT = height;
		
	data = new int[WIDTH][HEIGHT];

		
	for(int i = 0; i < width; i++)
	    {
		for(int j = 0; j < height; j++)
		    {
			data[i][j] = 0;
		    }
	    }
    }
	
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height)
    {
	if((infoflags & ImageObserver.ALLBITS) == ImageObserver.ALLBITS) {
	    System.out.println("ImageLoaded");
	}
	return true;
    }
	
    public void draw(Graphics g)
    {
	Font font = new Font("Serif", Font.BOLD, 44);
	g.setFont(font);
	Image cell_img;
	for(int i = 0; i < WIDTH; i++)
	    {
		for(int j = 0; j < HEIGHT; j++)
		    {
			g.drawRect(CELL_WIDTH * i, CELL_HEIGHT * j, 50, 50);
			g.drawString(Integer.toString(data[i][j]), 
				     (CELL_WIDTH) * i + 10,
				     (CELL_HEIGHT) * j+ 44);
		    }
	    }
    }

    public void setCell(int x, int y, int var)
    {
	if(x >= 0 && x < WIDTH && y >= 0 && y < HEIGHT) {
	    data[x][y] = var;
	}
    }
	
    public void load(String filename) {
	int cell_data;
	try {
	    BufferedReader br = new BufferedReader (
						    new FileReader(new File(filename)));
			
	    String line = br.readLine();
	    WIDTH = Integer.parseInt(line);
	    line = br.readLine();
	    HEIGHT = Integer.parseInt(line);

	    for(int i = 0; i < WIDTH; i++) {
		line = br.readLine();
		String[] texts = line.split(",");
		for(int j = 0; j < HEIGHT; j++) {
		    cell_data = Integer.parseInt(texts[j] + "");
		    data[i][j] = cell_data;
		}
	    }
	} catch (Exception e) {
	    e.printStackTrace();
	}
    }
	
    public void dumpToFile(String filename) {
	try {
	    PrintWriter pw = new PrintWriter(
					     new BufferedWriter(new FileWriter (new File(filename))));
	    pw.println(WIDTH);
	    pw.println(HEIGHT);
	    for(int i = 0; i < WIDTH; i++) {
		for(int j = 0; j < HEIGHT; j++) {
		    pw.print(data[i][j]);
		    if(j != (HEIGHT -1)) {
			    pw.print(",");	
		    }
		}
		pw.println("");
	    }
	    pw.close();
	} catch (Exception e) {
	    e.printStackTrace();
	}
    }
    
    public void resize(int w, int h) 
    {
	int[][] newData = new int[w][h];
	if(w >= WIDTH && h >= HEIGHT) {
	    for(int i = 0; i < WIDTH; i++) {
		for(int j = 0; j < HEIGHT; j++) {
		    newData[i][j] = data[i][j];
		}
	    }
	}
	else if(w >= WIDTH && h < HEIGHT) {
	    for(int i = 0; i < WIDTH; i++) {
		for(int j = 0; j < h; j++) {
		    newData[i][j] = data[i][j];
		}
	    }
	}
	else if(w < WIDTH && h >= HEIGHT) {
	    for(int i = 0; i < w; i++) {
		for(int j = 0; j < HEIGHT; j++) {
		    newData[i][j] = data[i][j];
		}
	    }
	}
	else {
	    for(int i = 0; i < w; i++) {
		for(int j = 0; j < h; j++) {
		    newData[i][j] = data[i][j];
		}
	    }
	}
	WIDTH = w;
	HEIGHT = h;
	data = newData;
    }
    public void save(Point p1, Point p2) {
	KILLRING_WIDTH = p2.x - p1.x + 1;
	KILLRING_HEIGHT = p2.y - p1.y + 1;
	killRing = new int[p2.x - p1.x + 1][p2.y - p1.y + 1];
	for(int i = p1.x; i <= p2.x; i++) {
	    for(int j = p1.y; j <= p2.y; j++) {
		killRing[i - p1.x][j - p1.y] = data[i][j];
	    }
	}
    }

    public void paste(Point p1) {
	if(killRing != null) {
	    for(int i = p1.x; ((i - p1.x) < KILLRING_WIDTH && i < WIDTH); i++) {
		for(int j = p1.y; ((j - p1.y) < KILLRING_HEIGHT && j < HEIGHT); j++) {
		    data[i][j] = killRing[i - p1.x ][j - p1.y];
		}
	    }
	}
    }
    
    public void cut(Point p1, Point p2) {
	killRing = new int[p2.x - p1.x + 1][p2.y - p1.y + 1];
	KILLRING_WIDTH = p2.x - p1.x + 1;
	KILLRING_HEIGHT = p2.y - p1.y + 1;
	for(int i = p1.x; i <= p2.x; i++) {
	    for(int j = p1.y; j <= p2.y; j++) {
		killRing[i - p1.x][j - p1.y] = data[i][j];
		data[i][j] = 0;
	    }
	}
    }
}
