import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.*;

public class Main extends JFrame implements ActionListener{

    /**
     * 
     */
    private static final long serialVersionUID = 1L;
    private JFrame mapFrame;
    private JFrame cellFrame;
    private JFrame controlFrame;
    private ControlPanel ctrlpanel;
    private GamePanel gpanel;
    private CellPanel cpanel;
	
    /**
     * @param args
     */
	
    public Main ()
    {
	mapFrame = new JFrame();
	cellFrame = new JFrame();
	controlFrame = new JFrame();
	cpanel = new CellPanel();
	gpanel = new GamePanel(cpanel);
	ctrlpanel = new ControlPanel(gpanel);
	JScrollPane scrollPane = new JScrollPane(gpanel);
	mapFrame.add(scrollPane);
	mapFrame.pack();
	cellFrame.add(cpanel);
	cellFrame.pack();
	controlFrame.add(ctrlpanel);
	controlFrame.pack();
	this.menuInit();
    }
	
    private void menuInit() {
	MenuBar menuBar = new MenuBar();
	this.mapFrame.setMenuBar(menuBar);
	Menu menuFile = new Menu("File");
	menuFile.addActionListener(this);
	menuBar.add(menuFile);
	MenuItem menuOpen = new MenuItem("Open", new MenuShortcut('O'));
	menuFile.add(menuOpen);
	MenuItem menuSave = new MenuItem("Save", new MenuShortcut('S'));
	menuFile.add(menuSave);
	menuFile.addSeparator();
	MenuItem menuExit = new MenuItem("Exit");
	menuFile.add(menuExit);

	//Add [View] menu
	Menu menuView = new Menu("View");
	menuView.addActionListener(this);
	menuBar.add(menuView);
	//Add [View]->[Zoom] menu
	MenuItem menuZoomIn = new MenuItem("ZoomIn", new MenuShortcut('Z'));
	menuView.add(menuZoomIn);
	//Add[View]->[UnZoom] menu
	MenuItem menuZoomOut = new MenuItem("ZoomOut" , new MenuShortcut('U'));
	menuView.add(menuZoomOut);
	
	Menu menuEdit = new Menu("Edit");
	menuEdit.addActionListener(this);
	menuBar.add(menuEdit);
	MenuItem menuCopy = new MenuItem("Copy", new MenuShortcut('C'));
	menuEdit.add(menuCopy);
	MenuItem menuCut = new MenuItem("Cut", new MenuShortcut('X'));
	menuEdit.add(menuCut);
	MenuItem menuPaste = new MenuItem("Paste", new MenuShortcut('P'));
	menuEdit.add(menuPaste);
    }
	
    public static void main(String[] args) {
	// TODO Auto-generated method stub
	Main main = new Main();
	main.mapFrame.setVisible(true);
	main.mapFrame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	main.cellFrame.setVisible(true);
	main.controlFrame.setVisible(true);
    }
	
    public void actionPerformed(ActionEvent e) {
	JFileChooser filechooser = new JFileChooser();
	if(e.getActionCommand() == "Open") {
	    System.out.println("Open");
	    int selected = filechooser.showOpenDialog(this);
	    if(selected == JFileChooser.APPROVE_OPTION) {
		gpanel.board.load(filechooser.getSelectedFile().getPath());
		System.out.println(filechooser.getSelectedFile().getPath());
	    } else if(selected == JFileChooser.CANCEL_OPTION) {
		System.out.println("Canceled!");
	    } else if(selected == JFileChooser.ERROR_OPTION) {
		System.out.println("Error!!");
	    }
	    gpanel.repaint();
	}
	if(e.getActionCommand() == "Save") {
	    System.out.println("Save");
	    int selected = filechooser.showSaveDialog(this);
	    if(selected == JFileChooser.APPROVE_OPTION) {
		gpanel.board.dumpToFile(filechooser.getSelectedFile().getPath());
		System.out.println(filechooser.getSelectedFile().getPath());
	    } else if(selected == JFileChooser.CANCEL_OPTION) {
		System.out.println("Canceled!");
	    } else if(selected == JFileChooser.ERROR_OPTION) {
		System.out.println("Error!!");
	    }
	}
	if(e.getActionCommand() == "Exit") {
	    System.exit(0);
	}
	if(e.getActionCommand() == "ZoomIn") {
	    gpanel.zoom();
	    gpanel.repaint();
	}
	if(e.getActionCommand() == "ZoomOut") {
	    gpanel.unzoom();
	    gpanel.repaint();
	}
	if(e.getActionCommand() == "Copy") {
	    gpanel.copy();
	    gpanel.repaint();
	}
	if(e.getActionCommand() == "Cut") {
	    gpanel.cut();
	    gpanel.repaint();
	}
	if(e.getActionCommand() == "Paste") {
	    gpanel.paste();
	    gpanel.repaint();
	}
    }
}
