/* 
 * FreeModbus Libary: A portable Modbus implementation for Modbus ASCII/RTU.
 * Copyright (c) 2010 Alexandr Litjagin (aka AlexRayne) <alexraynepe196@lavabit.com>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#include "runtime/lib.h"
#include "kernel/uos.h"
#include <kernel/internal.h>
#include <stddef.h>

#include <mb.h>
#include <../mbmulty_wrap.h>
#include <mbmaster.h>
#include <portevent.h>
#include <port.h>
#include <mbport.h>

#include "mblocal.h"

void modbus_master_task (void *data)
{
    eMBErrorCode    eStatus;
    MB_SERVE_DECL_FROM(data);
    MB_SERVE_PORT_DECL;

    eStatus = eMBInit( MB_RTU, MBAdress, 0, MB_BAUD, MB_PAR_EVEN );
    if (eStatus != MB_ENOERR)
        return;
    MBProtocolTimeOutOff();
    /* Enable the Modbus Protocol Stack. */
    eStatus = eMBEnable();
    if (eStatus != MB_ENOERR)
        return;

    while(1) {
        do {
            while (MBHasEvent()) {
                if (eMBPollMaster(  ) == MB_CLOSED)
                    break;
            }
            if (eMBState != STATE_CLOSED)
            ( void )eMBPollMaster(  );
        } while (MBHasEvent() && (eMBState != STATE_CLOSED));
        //DEBUG_MB(',');
        MBWaitEvent(  );
    }

    eMBDisable(  );
    eStatus = eMBClose(  );
}
