/* 
 * FreeModbus Libary: A portable Modbus implementation for Modbus ASCII/RTU.
 * Copyright (c) 2006 Christian Walter <wolti@sil.at>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * File: $Id: mbrtu.h,v 1.9 2006/12/07 22:10:34 wolti Exp $
 */

#ifndef _MB_RTU_H
#define _MB_RTU_H

#include <mbproto.h>
#include <mbmulty.h>


#ifdef __cplusplus
PR_BEGIN_EXTERN_C
#endif

eMBErrorCode MB_METHOD_DECL(eMBRTUInit, UCHAR slaveAddress, UCHAR ucPort, ULONG ulBaudRate,
                             eMBParity eParity );
void            MB_METHOD_DECL1(eMBRTUStart);
void            MB_METHOD_DECL1(eMBRTUStop);
eMBErrorCode    MB_METHOD_DECL(eMBRTUReceive, UCHAR * pucRcvAddress, UCHAR ** pucFrame, UFRAMESIZE * pusLength );
eMBErrorCode    MB_METHOD_DECL(eMBRTUSend, UCHAR slaveAddress, const UCHAR * pucFrame, UFRAMESIZE usLength );
eMBErrorCode    MB_METHOD_DECL(eMBRTUPost, UCHAR slaveAddress, const UCHAR * pucFrame, UFRAMESIZE usLength );
BOOL            MB_METHOD_DECL1(xMBRTUReceiveFSM);
BOOL            MB_METHOD_DECL1(xMBRTUTransmitFSM);
BOOL            MB_METHOD_DECL1(xMBRTUTimerT15Expired);
BOOL            MB_METHOD_DECL1(xMBRTUTimerT35Expired);


#define eMBRTUInit(...)     MB_METHOD_ACT(eMBRTUInit, __VA_ARGS__)
#define eMBRTUReceive(...)  MB_METHOD_ACT(eMBRTUReceive, __VA_ARGS__)
#define eMBRTUSend(...)     MB_METHOD_ACT(eMBRTUSend, __VA_ARGS__)
#define eMBRTUPost(...)     MB_METHOD_ACT(eMBRTUPost, __VA_ARGS__)
#define eMBRTUStart()       MB_METHOD_ACT1(eMBRTUStart)
#define eMBRTUStop()        MB_METHOD_ACT1(eMBRTUStop)
#define xMBRTUReceiveFSM()      MB_METHOD_ACT1(xMBRTUReceiveFSM)
#define xMBRTUTransmitFSM()     MB_METHOD_ACT1(xMBRTUTransmitFSM)
#define xMBRTUTimerT15Expired() MB_METHOD_ACT1(xMBRTUTimerT15Expired)
#define xMBRTUTimerT35Expired() MB_METHOD_ACT1(xMBRTUTimerT35Expired)

#ifdef __cplusplus
PR_END_EXTERN_C
#endif
#endif
