#ifndef _mb_multyport_wraper_rtu_h_
#define _mb_multyport_wraper_rtu_h_
/*
 * FreeModbus Libary: uOS-elvees Port
 * ru UTF8
    Copyright (C) 2015  Alexandr Litjagin (aka AlexRayne) AlexRaynePE196@gmail.com
                                                          AlexRaynePE196@hotbox.ru
   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/

#include <mbmulty.h>

/* ----------------------- Defines ------------------------------------------*/
#define MB_SER_PDU_SIZE_MIN     4       /*!< Minimum size of a Modbus RTU frame. */
#define MB_SER_PDU_SIZE_MAX     256     /*!< Maximum size of a Modbus RTU frame. */
#define MB_SER_PDU_SIZE_CRC     2       /*!< Size of CRC field in PDU. */
#define MB_SER_PDU_ADDR_OFF     0       /*!< Offset of slave address in Ser-PDU. */
#define MB_SER_PDU_PDU_OFF      1       /*!< Offset of Modbus-PDU in Ser-PDU. */

/* ----------------------- Type definitions ---------------------------------*/
typedef enum
{
    STATE_RX_IDLE,              /*!< Receiver is in idle state. */
    STATE_RX_INIT,              /*!< Receiver is in initial state. */
    STATE_RX_RCV,               /*!< Frame is beeing received. */
    STATE_RX_ERROR              /*!< If the frame is invalid. */
} eMBRcvState;

typedef enum
{
    STATE_TX_IDLE                /*!< Transmitter is in idle state. */
    , STATE_TX_INIT = STATE_TX_IDLE
    , STATE_TX_XMIT               /*!< Transmitter is in transfer state. */
    , STATE_TX_WAIT             //Transmiter waits when RX goes into idle
} eMBSndState;

#ifndef MB_SER_RECV_SIZE
#define MB_SER_RECV_SIZE MB_SER_PDU_SIZE_MAX
#endif

#if MB_MULTY_PORTS > 0
struct mb_rtu_s {
        mb_nif  mb;

        volatile eMBSndState SndState;
        volatile eMBRcvState RcvState;

        /*volatile*/ UCHAR  RTUBuf[MB_SER_RECV_SIZE];

        /*volatile*/ UCHAR *SndBufferCur;
        /*volatile*/ UFRAMESIZE SndBufferCount;

        UFRAMESIZE RcvBufferPos;
};
typedef struct mb_rtu_s mb_rtu_ctx;

#define MB_RTU      rtu_io
#define MB_RTUIF    mb_rtu_ctx* MB_RTU
#define MB_RTU_NET_DECL MB_RTUIF = (mb_rtu_ctx*)(MB_SELF->MB_NET)

#define eSndState   (MB_RTU->SndState)
#define eRcvState   (MB_RTU->RcvState)
#define ucRTUBuf    (MB_RTU->RTUBuf)
#define pucSndBufferCur     (MB_RTU->SndBufferCur)
#define usSndBufferCount    (MB_RTU->SndBufferCount)
#define usRcvBufferPos      (MB_RTU->RcvBufferPos)

#else
/* ----------------------- Static variables ---------------------------------*/
static volatile eMBSndState eSndState;
static volatile eMBRcvState eRcvState;

/*volatile*/ UCHAR  ucRTUBuf[MB_SER_RECV_SIZE];

static /*volatile*/ UCHAR *pucSndBufferCur;
static /*volatile*/ UFRAMESIZE usSndBufferCount;

static UFRAMESIZE usRcvBufferPos;

BOOL IsMBRTUFrameReceiving(void){
    return(eRcvState > STATE_RX_IDLE);
}

#endif//!#if MB_MULTY_PORTS > 0

#endif //_mb_multyport_wraper_rtu_h_
