/* 
 * FreeModbus Libary: A portable Modbus implementation for Modbus ASCII/RTU.
 * Copyright (c) 2010 Alexandr Litjagin (aka AlexRayne) <alexraynepe196@lavabit.com>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef _MBMASTER_H
#define _MBMASTER_H

#include <portgen.h>

#ifdef __cplusplus
PR_BEGIN_EXTERN_C
#endif

#include "mbport.h"
#include "mbproto.h"
#include "mbframe.h"
#include "mb.h"
#include <mbmulty.h>

/*! \ingroup modbus
 * \brief The main pooling loop of the Modbus Master protocol stack.
 *
 * This function must be called periodically. Internally the
 * function calls xMBPortEventGet() and waits for an event from the receiver or
 * transmitter state machines. 
 * The timer interval required is given by the application dependent Modbus slave timeout. 
 * besides internal frame timeout, Acknowledge from slave timeouts must be defined
 * MB_ACK_TIMEOUT                   - ack timeout
 * MB_TURNAROUND_TIMEOUT            - timeout after broadcast message
 * RETRY_LIMIT                      - sending tryes count
 * MB_ACKERROR_CB(eMBErrorCode)     - callback marco for invalid ack
 * MB_SENTOK_CB(eMBErrorCode)       - callback macro for ok ack
 * MB_ERROR_CB(eMBErrorCode)        - callback macro for send fail
 *
 * if MB_MIXED_MASTERSLAVE defined - flexible behaviour of protocol control uses - 
 *      received frames in idle processes as slave
 *      MBPostFrame starts master sending frame session
 * otherwise received frames omits
 * if MB_FLEX_TX defined - it try to use more flex SerialLine locking for transmit - 
 *     it try to start transmit right after frame completes, and waiting for starts
 *     about MB_TXLOCK_TIMEOUT time
 * 
 * \return If the protocol stack is not in the enabled state the function
 *   returns eMBErrorCode::MB_EILLSTATE. Otherwise it returns 
 *   eMBErrorCode::MB_ENOERR.
 */

#ifndef eMBPollMaster
#   define eMBPollMaster() MBS_METHOD_ACT1(eMBPollMaster)
#endif
eMBErrorCode    MBS_METHOD_DECL1( eMBPollMaster );

#define MBPostFrame(...) MB_METHOD_ACT(MBPostFrame, __VA_ARGS__)
eMBErrorCode    MBS_METHOD_DECL(MBPostFrame, UCHAR slaveAddress,
                            const UCHAR * pucFrame,
                            UFRAMESIZE usLength );
#define MBRepostFrame() MBS_METHOD_ACT1(MBRepostFrame)
eMBErrorCode    MBS_METHOD_DECL1(MBRepostFrame);


#ifdef MB_IS_MULTY
#define MBPostComplete  (MBC_SELF->PostState != MB_BUSY)
#define MBPostReady     (MBC_SELF->PostState != MB_BUSY)
#else
extern eMBErrorCode MBPostState;

extern MB_frame_PDU *   MBACKFrame;
extern UCHAR            MBACKAddress;
extern UFRAMESIZE       MBACKLength;

#define MBPostComple (MBPostState != MB_BUSY)
#define MBPostReady  (MBPostState != MB_BUSY)
#endif
/* ----------------------- Callback -----------------------------------------*/


#ifdef __cplusplus
PR_END_EXTERN_C
#endif
#endif
