/*
 * FreeModbus Libary: uOS-elvees Port
 * ru UTF8
    Copyright (C) 2015  Alexandr Litjagin (aka AlexRayne) AlexRaynePE196@gmail.com
                                                          AlexRaynePE196@hotbox.ru
   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
 */

#include "runtime/lib.h"
#include "kernel/uos.h"
#include <kernel/internal.h>
/* ----------------------- Modbus includes ----------------------------------*/
#include <port.h>
#include <mb.h>
#include <mbport.h>

#include "portevent.h"

typedef struct _EventsQue EventsQue;

void QueInit(EventsQue* dst){
    dst->rdi = 0;
    dst->wri = 0;
}

eMBEventType QueGet(EventsQue* src){
    unsigned idx = src->rdi;
    eMBEventType res = src->events[idx];
    src->events[idx] = (eMBEventType)0;
    if (res == 0)
        ;
    else
        src->rdi = (idx+1) & eQueueIMASK;
    return res;
}

CODE_ISR 
BOOL QuePut(EventsQue* src, eMBEventType data){
    unsigned idx = src->wri;
    eMBEventType res = src->events[idx];
    if (res > 0)
        return FALSE;
    src->events[idx] = data;
    src->wri = (idx+1) & eQueueIMASK;
    return TRUE;
}

BOOL QueHave(EventsQue* src){
    return (src->wri != src->rdi);
} 
/* ----------------------- Variables ----------------------------------------*/
#ifndef MB_IS_MULTY
EventsQue eQueuedEvent;
#endif

/* ----------------------- Start implementation -----------------------------*/
BOOL
MB_METHOD_DECL1(xMBPortEventInit)
{
    QueInit(&eQueuedEvent);
    DEBUG_MBprintf(vMB_trace, "mb[$%p]:events inited, signals $%p\n"
                            , MB_SELF, eQueuedEvent.signals_group);
    return TRUE;
}

#define MBPortEventSignal() MB_METHOD_ACT1(MBPortEventSignal)
void MB_METHOD_DECL1(MBPortEventSignal)
{
    mutex_group_t* g = eQueuedEvent.signals_group;
    if (g->waiter != NULL)
        mutex_awake(g->slot[0].lock, MB_SELF);
}

inline
void MB_print_event(eMBEventType eEvent){
    MB_putc(' ');
    MB_putc('e');
    MB_putc('0'+eEvent);
}

CODE_ISR 
BOOL MB_METHOD_DECL(xMBPortEventPost, eMBEventType eEvent )
{
    BOOL ok;
    if (MB_PortIsWithinException()){
        ok = QuePut(&eQueuedEvent, eEvent);
        MB_print_event(eEvent);
    }
    else {
        //запись событий у нас может происходить и из пользовательского потока 
        // для этого варианта придется блокировать проц
        arch_state_t x;
        arch_intr_disable (&x);
        bool_t hasev = MBHasEvent();
        ok = QuePut(&eQueuedEvent, eEvent);
        MB_print_event(eEvent);
        if (!hasev)  //полагаю что ожидалка включается только когда в очереди нет событий
            MBPortEventSignal();
        arch_intr_restore (x);
    }
#ifdef DEBUG_MB
    if (!ok)
        DEBUG_MB('"');
#endif
    return ok;
}

BOOL MB_METHOD_DECL(xMBPortEventGet, eMBEventType * eEvent )
{
    eMBEventType res = QueGet(&eQueuedEvent);
    DEBUG_MBprintf(vMB_debug, "mb[$%p]:have event %x\n", MB_SELF, res);
    if (res == 0)
        return FALSE;
    if (res >= EV_POLL_UNCKNOWN)
    if (eQueuedEvent.OnNoPollEvent)
        res = (*eQueuedEvent.OnNoPollEvent)(MB_WITH_SELF res);
    *eEvent = res;
    return TRUE;
}

BOOL MB_METHOD_DECL1(MBHasEvent){
    return QueHave(&eQueuedEvent);
}

BOOL MB_METHOD_DECL1(MBWaitEvent)
{
    mutex_group_t *g = eQueuedEvent.signals_group;
    mutex_t *m = NULL;
    void *msg  = NULL;
    trace_probe_mb_ev_on();
    DEBUG_MBprintf(vMB_trace, "mb[$%p]:wait event\n", MB_SELF);
    mutex_group_wait (g, &m, &msg);
    trace_probe_mb_ev_off();
    return m != NULL;
}

