#ifndef _timers_defs_h_
#define _timers_defs_h_

/*
 * Copyright (C) 2010  Alexandr Litjagin (aka AlexRayne) AlexRaynePE196@lavabit.com, 
 *                                                       AlexRaynePE196@hotbox.ru
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the Institute nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * This file is part of the avr stuff library.
 */

#include <avr/io.h>


#define TIMER_SCALE_OFF    ((0 << CS22) | (0 << CS21) | (0 << CS20))
#define TIMER_SCALE_MASK    ((1 << CS22) | (1 << CS21) | (1 << CS20))

#define TIMERex_SCALE_1      ((0 << CS22) | (0 << CS21) | (1 << CS20))
#define TIMERex_SCALE_8      ((0 << CS22) | (1 << CS21) | (0 << CS20))
#define TIMERex_SCALE_64     ((0 << CS22) | (1 << CS21) | (1 << CS20))
#define TIMERex_SCALE_256    ((1 << CS22) | (0 << CS21) | (0 << CS20))
#define TIMERex_SCALE_1024   ((1 << CS22) | (0 << CS21) | (1 << CS20))
#define TIMERex_SCALE_T2FALL ((1 << CS22) | (1 << CS21) | (0 << CS20))
#define TIMERex_SCALE_T2RISE ((1 << CS22) | (1 << CS21) | (1 << CS20))

#define TIMERin_SCALE_1      ((0 << CS22) | (0 << CS21) | (1 << CS20))
#define TIMERin_SCALE_8      ((0 << CS22) | (1 << CS21) | (0 << CS20))
#define TIMERin_SCALE_32     ((0 << CS22) | (1 << CS21) | (1 << CS20))
#define TIMERin_SCALE_64     ((1 << CS22) | (0 << CS21) | (0 << CS20))
#define TIMERin_SCALE_128    ((1 << CS22) | (0 << CS21) | (1 << CS20))
#define TIMERin_SCALE_256    ((1 << CS22) | (1 << CS21) | (0 << CS20))
#define TIMERin_SCALE_1024   ((1 << CS22) | (1 << CS21) | (1 << CS20))

#if defined(__AVR_ATmega162__)\
    || defined(__AVR_ATmega164__) || defined(__AVR_ATmega164P__) || defined(__AVR_ATmega164PA__)\
    || defined(__AVR_ATmega324P__) || defined(__AVR_ATmega324A__) || defined(__AVR_ATmega324PA__)\
    || defined(__AVR_ATmega644P__) || defined(__AVR_ATmega644A__) || defined(__AVR_ATmega644PA__)\
    || defined(__AVR_ATmega1284P__)     || defined(__AVR_ATmega1284__)

#define TIMER0_SCALE_1      TIMERex_SCALE_1
#define TIMER0_SCALE_8      TIMERex_SCALE_8
#define TIMER0_SCALE_64     TIMERex_SCALE_64
#define TIMER0_SCALE_256    TIMERex_SCALE_256
#define TIMER0_SCALE_1024   TIMERex_SCALE_1024
#define TIMER0_SCALE_T2FALL TIMERex_SCALE_T2FALL
#define TIMER0_SCALE_T2RISE TIMERex_SCALE_T2RISE

#define TIMER2_SCALE_1      TIMERin_SCALE_1
#define TIMER2_SCALE_8      TIMERin_SCALE_8
#define TIMER2_SCALE_32     TIMERin_SCALE_32
#define TIMER2_SCALE_64     TIMERin_SCALE_64
#define TIMER2_SCALE_128    TIMERin_SCALE_128
#define TIMER2_SCALE_256    TIMERin_SCALE_256
#define TIMER2_SCALE_1024   TIMERin_SCALE_1024

#elif defined(__AVR_ATmega128__) || defined(__AVR_ATmega128A__)

#define TIMER0_SCALE_1      TIMERin_SCALE_1
#define TIMER0_SCALE_8      TIMERin_SCALE_8
#define TIMER0_SCALE_32     TIMERin_SCALE_32
#define TIMER0_SCALE_64     TIMERin_SCALE_64
#define TIMER0_SCALE_128    TIMERin_SCALE_128
#define TIMER0_SCALE_256    TIMERin_SCALE_256
#define TIMER0_SCALE_1024   TIMERin_SCALE_1024

#define TIMER2_SCALE_1      TIMERex_SCALE_1
#define TIMER2_SCALE_8      TIMERex_SCALE_8
#define TIMER2_SCALE_64     TIMERex_SCALE_64
#define TIMER2_SCALE_256    TIMERex_SCALE_256
#define TIMER2_SCALE_1024   TIMERex_SCALE_1024
#define TIMER2_SCALE_T2FALL TIMERex_SCALE_T2FALL
#define TIMER2_SCALE_T2RISE TIMERex_SCALE_T2RISE

#endif

#endif
